<?php $__env->startSection('title', 'Admin | Profits'); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $months = [
            1 => 'January',
            2 => 'February',
            3 => 'March',
            4 => 'April',
            5 => 'May',
            6 => 'June',
            7 => 'July',
            8 => 'August',
            9 => 'September',
            10 => 'October',
            11 => 'November',
            12 => 'December',
        ];
    ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="main-content">
                <section class="section">
                    <div class="section-body">
                        <div class="row">
                            <div class="col-12 col-md-12 col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Profit</h4>
                                    </div>
                                    <div class="card-body row">
                                        <!-- Market Dropdown -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Markets</label>
                                                <select class="form-control" id="market_id" name="market_id">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($market->id); ?>" <?php if(request()->has('type') ? (request()->query('type') === 'market' ? request()->query('market_id') == $market->id : false) : false): echo 'selected'; endif; ?>>
                                                            <?php echo e($market->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <!-- Date Dropdowns -->
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="market_year" class="form-control">
                                                        <?php for($year = date('Y'); $year >= 2000; $year--): ?>
                                                            <option value="<?php echo e($year); ?>"
                                                                <?php if(request()->query('year', 0) == $year): echo 'selected'; endif; ?>>
                                                                <?php echo e($year); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <select id="market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"
                                                                <?php if(request()->query('month', 0) == $key): echo 'selected'; endif; ?>>
                                                                <?php echo e($value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <select id="market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        <?php for($day = 1; $day <= 31; $day++): ?>
                                                            <option value="<?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>"
                                                                <?php if(request()->query('day', 0) == $day): echo 'selected'; endif; ?>>
                                                                <?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="market_get_button">Get</button>
                                            <?php if(request()->has('type')): ?>
                                                <?php if(request()->type == 'market'): ?>
                                                    <h5> <span>Total amount: <?php echo e($data['totalBidAmount']); ?></span></h5>
                                                    <h5> <span>Total win amount: <?php echo e($data['totalWinAmount']); ?></span></h5>
                                                    <h5 class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ]); ?>">

                                                        <?php if($data['profit'] == 0): ?>
                                                            <span>Profit: 0 </span>
                                                        <?php else: ?>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] > 0]); ?>">Loss: </span>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] < 0]); ?>">Profit: </span>
                                                            <?php echo e(abs($data['profit']) ?? 0); ?>

                                                        <?php endif; ?>
                                                        </h3>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <!-- Startline Market Dropdowns -->
                                    <div class="card-body row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Startline Markets</label>
                                                <select class="form-control" id="startline_market_id"
                                                    name="startline_market_id">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = $startlineMarkets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($market->id); ?>" <?php if(request()->has('type') ? (request()->query('type') === 'startline_market' ? request()->query('market_id') == $market->id : false) : false): echo 'selected'; endif; ?>>
                                                            <?php echo e($market->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="startline_year" class="form-control">
                                                        <?php for($year = date('Y'); $year >= 2000; $year--): ?>
                                                            <option value="<?php echo e($year); ?>"
                                                                <?php if(request()->query('year', 0) == $year): echo 'selected'; endif; ?>>
                                                                <?php echo e($year); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <select id="startline_market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"
                                                                <?php if(request()->query('month', 0) == $key): echo 'selected'; endif; ?>>
                                                                <?php echo e($value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <select id="startline_market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        <?php for($day = 1; $day <= 31; $day++): ?>
                                                            <option value="<?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>"
                                                                <?php if(request()->query('day', 0) == $day): echo 'selected'; endif; ?>>
                                                                <?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="startline_get_button">Get</button>
                                            <?php if(request()->has('type')): ?>
                                                <?php if(request()->type == 'startline_market'): ?>
                                                    <h5> <span>Total amount: <?php echo e($data['totalBidAmount']); ?></span></h5>
                                                    <h5> <span>Total win amount: <?php echo e($data['totalWinAmount']); ?></span></h5>
                                                    <h5 class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ]); ?>">

                                                        <?php if($data['profit'] == 0): ?>
                                                            <span>Profit: 0 </span>
                                                        <?php else: ?>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] > 0]); ?>">Loss: </span>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] < 0]); ?>">Profit: </span>
                                                            <?php echo e(abs($data['profit']) ?? 0); ?>

                                                        <?php endif; ?>
                                                        </h3>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <!-- Desawar Market Dropdowns -->
                                    <div class="card-body row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Desawar Markets</label>
                                                <select class="form-control" id="desawar_market_id"
                                                    name="desawar_market_id">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = $desawarMarkets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($market->id); ?>" <?php if(request()->has('type') ? (request()->query('type') === 'desawar_market' ? request()->query('market_id') == $market->id : false) : false): echo 'selected'; endif; ?>>
                                                            <?php echo e($market->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="desawar_year" class="form-control">
                                                        <?php for($year = date('Y'); $year >= 2000; $year--): ?>
                                                            <option value="<?php echo e($year); ?>"
                                                                <?php if(request()->query('year', 0) == $year): echo 'selected'; endif; ?>>
                                                                <?php echo e($year); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <select id="desawar_market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"
                                                                <?php if(request()->query('month', 0) == $key): echo 'selected'; endif; ?>>
                                                                <?php echo e($value); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <select id="desawar_market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        <?php for($day = 1; $day <= 31; $day++): ?>
                                                            <option value="<?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>"
                                                                <?php if(request()->query('day', 0) == $day): echo 'selected'; endif; ?>>
                                                                <?php echo e(str_pad($day, 2, '0', STR_PAD_LEFT)); ?>

                                                            </option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="desawar_get_button">Get</button>
                                            <?php if(request()->has('type')): ?>
                                                <?php if(request()->type == 'desawar_market'): ?>
                                                    <h5> <span>Total amount: <?php echo e($data['totalBidAmount']); ?></span></h5>
                                                    <h5> <span>Total win amount: <?php echo e($data['totalWinAmount']); ?></span></h5>
                                                    <h5 class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ]); ?>">

                                                        <?php if($data['profit'] == 0): ?>
                                                            <span>Profit: 0 </span>
                                                        <?php else: ?>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] > 0]); ?>">Loss: </span>
                                                            <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['d-none' => $data['profit'] < 0]); ?>">Profit: </span>
                                                            <?php echo e(abs($data['profit']) ?? 0); ?>

                                                        <?php endif; ?>
                                                        </h3>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            function handleGetButton(getButtonSelector, typeSelector, yearSelector, monthSelector, daySelector,
                type) {
                $(getButtonSelector).on('click', function() {
                    let typeId = $(typeSelector).val();
                    let year = $(yearSelector).val();
                    let month = $(monthSelector).val();
                    let day = $(daySelector).val();

                    let url = new URL(window.location.origin + window.location.pathname);
                    url.searchParams.set('type', type);
                    url.searchParams.set('market_id', typeId);
                    url.searchParams.set('year', year);
                    url.searchParams.set('month', month);
                    url.searchParams.set('day', day);

                    window.location.href = url.toString();
                });
            }

            handleGetButton('#market_get_button', '#market_id', '#market_year', '#market_month', '#market_day',
                'market');
            handleGetButton('#startline_get_button', '#startline_market_id', '#startline_year', '#startline_month',
                '#startline_day', 'startline_market');
            handleGetButton('#desawar_get_button', '#desawar_market_id', '#desawar_year', '#desawar_month',
                '#desawar_day', 'desawar_market');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/profits/index.blade.php ENDPATH**/ ?>