<?php $__env->startSection('title','Admin | General Win History'); ?>
<?php $__env->startSection('content'); ?>
<div class="loader"></div>
<div id="app">
    <div class="main-wrapper main-wrapper-1">
        <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Main Content -->
        <div class="main-content">
            <section class="section">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>General Markets Record</h4>
                                <form action="<?php echo e(route('markets.win-history')); ?>" method="GET" class="form-inline mr-auto">
                                    <div class="search-element">
                                        <input name="searchValue" id="myInput" class="form-control" <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?> type="search" placeholder="Search" aria-label="Search" data-width="200">
                                        <button class="btn" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="card-body p-2">
                                <div class="table-responsive">
                                    <table data-searching="false" data-paging="false" data-info="false" data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Market Name</th>
                                                <th>Winner Name</th>
                                                <th>Session</th>
                                                <th>Amount</th>
                                                <th>Number</th>
                                                <th>Win Amount</th>
                                                <th>Created At</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $winHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($wh->id); ?></td>
                                                <td><?php echo e($wh->market->name); ?></td>
                                                <td><?php echo e($wh->user->name); ?></td>
                                                <td><?php echo e($wh->session); ?></td>
                                                <td><?php echo e($wh->amount); ?></td>
                                                <td><?php echo e($wh->number. ' (' . $wh->gameType->name . ')'); ?></td>
                                                <td><?php echo e($wh->win_amount); ?></td>
                                                <td><?php echo e($wh->created_at); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="m-2" id="pagination">
                                    <?php echo e($winHistory->links('pagination.custom')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/markets/win-history.blade.php ENDPATH**/ ?>