<?php $__env->startSection('title', 'Agent | Users '); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.agent_navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Users</h4>
                                    <form action="<?php echo e(route('agent.users.index')); ?>" method="GET"
                                        class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Balance</th>
                                                    <th>Total Game Amount</th>
                                                    <th>Total Won</th>
                                                    <th>Total Withdraw</th>
                                                    <th>Total Bonus</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($user->id); ?></td>
                                                        <td>
                                                            <?php echo e($user->name); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e(substr($user->phone, 0, 7)); ?>****
                                                        </td>
                                                        <td><?php echo e($user->balance); ?></td>
                                                        <td>
                                                            <?php echo e($user->total_market_game_amount + $user->total_startLine_game_amount + $user->total_desawar_game_amount ??
                                                                'no games yet'); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($user->total_market_win_amount + $user->total_startline_win_amount + $user->total_desawar_win_amount); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($user->total_withdraw_success_amount); ?>

                                                        </td>
                                                        <td><?php echo e($user->bonus); ?></td>
                                                        <td><?php echo e($user->created_at); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($users->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/agent/users/index.blade.php ENDPATH**/ ?>