<?php $__env->startSection('title', 'Admin | Deposit History'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Deposit History </h4>
                                    <form action="<?php echo e(route('deposit-history.index')); ?>" method="GET"
                                        class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Amount</th>
                                                    <th>UTR</th>
                                                    <th>Request Type</th>
                                                    <th>Deposit Mode</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                <?php $__currentLoopData = $depositHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($deposit->id); ?></td>
                                                        <td><?php echo e($deposit->user->name); ?></td>
                                                        <td>
                                                            <a href="<?php echo e(route('users.Detail', $deposit->user->id)); ?>">
                                                                <?php if(!env('APP_DEBUG')): ?>
                                                                    <?php echo e($deposit->user->phone); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(substr($deposit->user->phone, 0, 3) . '****' . substr($deposit->user->phone, 7, 10)); ?>

                                                                <?php endif; ?>
                                                            </a>
                                                        </td>
                                                        <td><?php echo e($deposit->amount); ?></td>
                                                        <td><?php echo e($deposit->utr); ?></td>
                                                        <td><?php echo e($deposit->request_type); ?></td>
                                                        <td><?php echo e($deposit->deposit_mode); ?></td>
                                                        <td class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'text-info' => $deposit->status == 'pending',
                                                            'text-success' => $deposit->status == 'success',
                                                            'text-danger' => $deposit->status == 'failed',
                                                        ]); ?>"><?php echo e($deposit->status); ?></td>
                                                        <?php if($deposit->status == 'pending'): ?>
                                                            <td>
                                                                <a href="<?php echo e(route('deposit-request.accept', ['id' => $deposit->id])); ?>"
                                                                    class="btn btn-outline-primary">Accept</a>|
                                                                <a href="<?php echo e(route('deposit-request.reject', ['id' => $deposit->id])); ?>"
                                                                    class="btn btn-outline-primary">Reject</a>
                                                            </td>
                                                        <?php else: ?>
                                                            <td> No Action </td>
                                                        <?php endif; ?>
                                                        <td><?php echo e($deposit->created_at); ?></td>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($depositHistories->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/deposit-history/index.blade.php ENDPATH**/ ?>