<?php $__env->startSection('title', 'Admin | Users '); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Users</h4>
                                    <form action="<?php echo e(route('users.index')); ?>" method="GET" class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                    <div class="card-header-form">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-markets')): ?>
                                            <div class="ml-5 form-group">
                                                <a href="<?php echo e(route('users.create')); ?>" class="btn btn-outline-primary">Create</a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Password</th>
                                                    <th>Balance</th>
                                                    <th>Total Game Amount</th>
                                                    <th>Total Won</th>
                                                    <th>Total Withdraw</th>
                                                    <th>Total Bonus</th>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.toogle-blocked.change')): ?>
                                                        <th>Blocked | Unblocked</th>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-deduct-balance-users')): ?>
                                                        <th>Add/Deduct Balance</th>
                                                    <?php endif; ?>
                                                    <th>Action</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($user->id); ?></td>
                                                        <td>
                                                            <a
                                                                href="<?php echo e(route('users.Detail', $user->id)); ?>"><?php echo e($user->name); ?></a>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo e(route('users.Detail', $user->id)); ?>">
                                                                <?php if(!env('APP_DEBUG')): ?>
                                                                    <?php echo e($user->phone); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(substr($user->phone, 0, 3) . '****' . substr($user->phone, 7, 10)); ?>

                                                                <?php endif; ?>
                                                            </a>
                                                        </td>
                                                        <td><?php echo e($user->password_show); ?></td>
                                                        <td><?php echo e($user->balance); ?></td>
                                                        <td>
                                                            <?php echo e($user->total_market_game_amount + $user->total_startLine_game_amount + $user->total_desawar_game_amount ??
                                                                'no games yet'); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($user->total_market_win_amount + $user->total_startline_win_amount + $user->total_desawar_win_amount); ?>

                                                        </td>
                                                        <td>
                                                            <?php echo e($user->total_withdraw_success_amount); ?>

                                                        </td>
                                                        <td><?php echo e($user->bonus); ?></td>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.toogle-blocked.change')): ?>
                                                            <td>
                                                                <div class="mt-3">
                                                                    <div class="selectgroup ">
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio" value="1"
                                                                                name="blocked<?php echo e($user->id); ?>"
                                                                                class="selectgroup-input-radio"
                                                                                <?php if($user->blocked == 1): ?> checked <?php endif; ?>
                                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,1)">
                                                                            <span class="selectgroup-button">Blocked </span>
                                                                        </label>
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio"
                                                                                name="blocked<?php echo e($user->id); ?>"
                                                                                value="0" class="selectgroup-input-radio"
                                                                                <?php if($user->blocked == 0): ?> checked <?php endif; ?>
                                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,0)">
                                                                            <span class="selectgroup-button">Unblock</span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        <?php endif; ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-deduct-balance-users')): ?>
                                                            <td><a href="<?php echo e(route('users.change-balance.show', ['user' => $user->id])); ?>"
                                                                    class="btn btn-outline-primary">Add | Deduct | Password</a>
                                                            </td>
                                                        <?php endif; ?>
                                                        <td>
                                                            <a target="_blank" href="https://wa.me/+91<?php echo e($user->phone); ?>"
                                                                class="btn btn-outline-primary">Open WhatsApp</a>
                                                            
                                                            <?php if(env('ADVANCE_MATKA', 0)): ?>
                                                                <form action="<?php echo e(route('users.destroy', $user->id)); ?>"
                                                                    method="POST" class="d-inline">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="submit"
                                                                        class="btn btn-outline-danger">Delete</button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo e($user->created_at); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($users->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <div class="modal fade bd-example-modal-xl" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-center w-100" id="myLargeModalLabel">User Profile</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-6 mb-5">
                            <h5>User Details</h5>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <p>User Status</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="user_status">
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Wallet Balance</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="user_wallet_balance"></p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 flex">
                                <a href="/" id="add_points" class="btn btn-primary">Add or Withdraw Points</a>
                            </div>
                        </div>
                        <div class="col-6 mb-5">
                            <h5>Profile Information</h5>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Full Name</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="user_name"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Phone</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="user_phone"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Registered On</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="user_created_on"></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mb-5">
                            <h5>Payment Information</h5>
                            <div class="col-6">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Account Holder Name</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="account_name">
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="row">
                                    <div class="col-6">
                                        <p>Account Number</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="account_number"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="row">
                                    <div class="col-6">
                                        <p>IFSC Code</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="ifsc_code"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="row">
                                    <div class="col-6">
                                        <p>UPI ID</p>
                                    </div>
                                    <div class="col-6">
                                        <p id="upi_id"></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 mb-5">
                            <h5>Withdraw Points Request</h5>
                            <div class="table-responsive">
                                <table data-searching="false" data-paging="false" data-info="false"
                                    data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Amount</th>
                                            <th>Request Type</th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="history_table">
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="col-12 mb-5">
                            <h5>Bid History</h5>
                            <div class="table-responsive">
                                <table data-searching="false" data-paging="false" data-info="false"
                                    data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Game Name</th>
                                            <th>Game Type</th>
                                            <th>Digits</th>
                                            <th>Points</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody id="bid_table">
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="col-12">
                            <h5>Transactions</h5>
                            <div class="table-responsive">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home"
                                            role="tab" aria-controls="home" aria-selected="true">All</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile"
                                            role="tab" aria-controls="profile" aria-selected="false">Credit</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact"
                                            role="tab" aria-controls="contact" aria-selected="false">Debit</a>
                                    </li>
                                </ul>
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="home" role="tabpanel"
                                        aria-labelledby="home-tab">
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false"
                                                data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>S.No</th>
                                                        <th>Points</th>
                                                        <th>Transaction Note</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="all_transactions_table">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="profile" role="tabpanel"
                                        aria-labelledby="profile-tab">
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false"
                                                data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>S.No</th>
                                                        <th>Points</th>
                                                        <th>Transaction Note</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="all_credits_table">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="contact" role="tabpanel"
                                        aria-labelledby="contact-tab">
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false"
                                                data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>S.No</th>
                                                        <th>Points</th>
                                                        <th>Transaction Note</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="all_debit_table">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
        function toogleBlock(id, block) {
            $.ajax({
                url: "<?php echo e(route('users.toogle-blocked.change')); ?>",
                type: "POST",
                data: {
                    user_id: id,
                    blocked: block
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                        .attr('content')
                },
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/users/index.blade.php ENDPATH**/ ?>