<?php $__env->startSection('title', 'Admin | General Market'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success">
                                    <?php echo e(session('success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="card">
                                <div class="card-header">
                                    <h4>General Markets</h4>
                                    <form action="<?php echo e(route('markets.index')); ?>" method="GET" class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                    <div class="card-header-form">
                                        <div class="input-group">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create-markets')): ?>
                                                <div class="ml-5 form-group">
                                                    <a href="<?php echo e(route('markets.create')); ?>"
                                                        class="btn btn-outline-primary">Create</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Current Status</th>
                                                    <th>Game Disabled?</th>
                                                    <th>Saturday Open</th>
                                                    <th>Sunday Open</th>
                                                    <th>Auto Result</th>
                                                    <th>Open Time</th>
                                                    <th>Close Time</th>
                                                    <th>Open Result Time</th>
                                                    <th>Close Result Time</th>
                                                    <th>Created At</th>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['delete-markets', 'edit-markets'])): ?>
                                                        <th class="col-2">Action</th>
                                                    <?php endif; ?>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($market->id); ?></td>
                                                        <td><?php echo e($market->name); ?></td>
                                                        <td class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'text-success' => $market->game_on,
                                                            'text-danger' => !$market->game_on,
                                                        ]); ?>">
                                                            <?php echo e($market->game_on ? 'OPEN NOW' : 'CLOSED NOW'); ?>

                                                        </td>
                                                        <td><?php echo e($market->disable_game ? 'YES' : 'NO'); ?></td>
                                                        <td><?php echo e($market->saturday_open ? 'Open' : 'Close'); ?></td>
                                                        <td><?php echo e($market->sunday_open ? 'Open' : 'Close'); ?></td>
                                                        <td><?php echo e($market->auto_result ? 'On' : 'Off'); ?></td>
                                                        <td><?php echo e($market->open_time); ?></td>
                                                        <td><?php echo e($market->close_time); ?></td>
                                                        <td><?php echo e($market->open_result_time); ?></td>
                                                        <td><?php echo e($market->close_result_time); ?></td>
                                                        <td><?php echo e($market->created_at); ?></td>
                                                        <td>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-markets')): ?>
                                                                <a href="<?php echo e(route('markets.edit', ['market' => $market->id])); ?>"
                                                                    class="btn btn-outline-primary">
                                                                    Edit
                                                                </a>
                                                                |
                                                            <?php endif; ?>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-markets')): ?>
                                                                <a href="<?php echo e(route('markets.destroy', ['market' => $market->id])); ?>"
                                                                    class="btn btn-outline-primary deleteBtn">
                                                                    Delete
                                                                </a>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($markets->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $('.deleteBtn').click(function(e) {
            e.preventDefault();
            // show swal
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this record!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = $(this).attr('href');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/markets/index.blade.php ENDPATH**/ ?>