<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php if(auth()->check() && auth()->user()->role == 'agent'): ?>
        <title> <?php echo $__env->yieldContent('title', 'Agent Dashboard'); ?> </title>
    <?php else: ?>
        <title> <?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?> </title>
    <?php endif; ?>
    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/app.min.css')); ?>">
    <!-- Template CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/components.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/bundles/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/bundles/jquery-selectric/selectric.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(asset('assets/backend/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css')); ?>">
    
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"
        integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
    <!-- Custom style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/backend/css/custom.css')); ?>">
    <link rel='shortcut icon' type='image/x-icon' href='<?php echo e(asset('favicon.png')); ?>' />
    
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.css" />
    <style>
        table.dataTable td {
            font-size: 15px;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<main>
    <?php echo $__env->yieldContent('content'); ?>
</main>
<script src="<?php echo e(asset('assets/backend/js/app.min.js')); ?>"></script>
<!-- Page Specific JS File -->
<script src="<?php echo e(asset('assets/backend/js/page/index.js')); ?>"></script>
<!-- Template JS File -->
<script src="<?php echo e(asset('assets/backend/js/scripts.js')); ?>"></script>
<!-- Custom JS File -->
<script src="<?php echo e(asset('assets/backend/js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/backend/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
    $(document).ready(function() {
        $('#myTable').DataTable({
            language: {
                zeroRecords: "No data available"
            }
        })
    });
</script>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/layouts/app.blade.php ENDPATH**/ ?>