<?php $__env->startSection('title', 'Admin | General Records'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>

    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>General Markets Record</h4>
                                    <form action="<?php echo e(route('markets.records')); ?>" method="GET" class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Market Name</th>
                                                    <th>User Name</th>
                                                    <th>User Phone</th>
                                                    <th>Session</th>
                                                    <th>Number</th>
                                                    <th>Amount</th>
                                                    <th>Win Amount</th>
                                                    <th>Status</th>
                                                    <th>Created At</th>
                                                    
                                                    <th>Actions</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $marketRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($record->id); ?></td>
                                                        <td><?php echo e($record->market->name); ?></td>
                                                        <td><?php echo e($record->user->name); ?></td>
                                                        <td>
                                                            <?php if(!env('APP_DEBUG')): ?>
                                                                <?php echo e($record->user->phone); ?>

                                                            <?php else: ?>
                                                                <?php echo e(substr($record->user->phone, 0, 3) . '****' . substr($record->user->phone, 7, 10)); ?>

                                                            <?php endif; ?>

                                                        </td>
                                                        <td><?php echo e($record->session == 'null' ? '' : $record->session); ?></td>
                                                        <td><?php echo e($record->number . ' (' . $record->gameType->name . ')'); ?>

                                                        </td>
                                                        <td><?php echo e($record->amount); ?></td>
                                                        <td><?php echo e($record->win_amount ?? 'NULL'); ?></td>
                                                        <td class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'text-info' => $record->status == 'PENDING',
                                                            'text-success' => $record->status == 'SUCCESS',
                                                            'text-danger' => $record->status == 'FAILED',
                                                        ]); ?>">
                                                            <?php echo e($record->status); ?>

                                                        </td>
                                                        <td><?php echo e($record->created_at); ?></td>
                                                        <td>
                                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                                data-target="#editBidModal<?php echo e($record->id); ?>">
                                                                <i class="fas fa-edit"></i>
                                                            </button>
                                                            <!-- Modal -->
                                                            <div class="modal fade" id="editBidModal<?php echo e($record->id); ?>"
                                                                tabindex="-1" role="dialog"
                                                                aria-labelledby="editBidModalLabel<?php echo e($record->id); ?>"
                                                                aria-hidden="true">
                                                                <div class="modal-dialog" role="document">
                                                                    <div class="modal-content">
                                                                        <style>
                                                                            .modal {
                                                                                z-index: 1050;
                                                                                /* Ensure the modal appears above other content */
                                                                            }

                                                                            .interfering-div {
                                                                                z-index: 1030;
                                                                            }

                                                                            .modal-backdrop {
                                                                                opacity: 0.5;
                                                                                display: none;
                                                                                z-index: 1040;
                                                                            }
                                                                        </style>
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title"
                                                                                id="editBidModalLabel<?php echo e($record->id); ?>">
                                                                                Edit Bid</h5>
                                                                            <button type="button" class="close"
                                                                                data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <!-- Form for editing bid -->
                                                                            <form id="editBidForm<?php echo e($record->id); ?>"
                                                                                action="<?php echo e(route('markets.records.update')); ?>"
                                                                                method="POST">
                                                                                <?php echo csrf_field(); ?>
                                                                                
                                                                                <input type="hidden" name="id"
                                                                                    value="<?php echo e($record->id); ?>">
                                                                                
                                                                                <input type="hidden" name="market_type"
                                                                                    value="market">
                                                                                <!-- Number input -->
                                                                                <div class="form-group">
                                                                                    <label for="number">Number:</label>
                                                                                    <input type="text"
                                                                                        value="<?php echo e($record->number); ?>"
                                                                                        class="form-control" id="number"
                                                                                        name="number">
                                                                                </div>
                                                                                <!-- Amount input -->
                                                                                <div class="form-group">
                                                                                    <label for="amount">Amount:</label>
                                                                                    <input type="text"
                                                                                        value="<?php echo e($record->amount); ?>"
                                                                                        class="form-control" id="amount"
                                                                                        name="amount">
                                                                                </div>
                                                                                <button type="submit"
                                                                                    class="btn btn-primary">Submit</button>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($marketRecords->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/markets/records.blade.php ENDPATH**/ ?>