<?php $__env->startSection('title', 'Admin | General Win History'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header" style="display: block;">
                                    <form action="<?php echo e(url('/markets/data')); ?>" method="get">
                                        <div class="row">
                                            <h4>General Markets Record (<?php echo e(isset($date) ? $date : date('Y-m-d')); ?>)</h4>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="card-content">
                                                    <div class="form-group mb-3">
                                                        <label>Date</label>
                                                        <input type="date" name="date" class="form-control datepicker"
                                                            value="<?php echo e(isset($date) ? $date : date('Y-m-d')); ?>"
                                                            placeholder="YYYY/MM/DD">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card-content">
                                                    <div class="form-group mb-3">
                                                        <label>Market Name</label>
                                                        <select class="form-control" required name="market_id">
                                                            <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($type->id); ?>"
                                                                    <?php echo e(request()->get('market_id') == $type->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($type->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card-content">
                                                    <div class="form-group mb-3">
                                                        <label>Market Time</label>
                                                        <select class="form-control" name="market_time">
                                                            <option value="open"
                                                                <?php echo e(request()->get('market_time') == 'open' ? 'selected' : ''); ?>>
                                                                Open</option>
                                                            <option value="close"
                                                                <?php echo e(request()->get('market_time') == 'close' ? 'selected' : ''); ?>>
                                                                Close</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="card-content">
                                                    <button type="submit" class="btn btn-primary">GET</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    <div class="card-body px-5 py-3 mb-5">


                                        <div style="display: flex; justify-content: space-between; overflow-x: scroll;">
                                            <div>
                                                <div class="bold text-center">Sr No.</div>
                                                <?php for($i = 1; $i <= $count; $i++): ?>
                                                    <div class="text-center">
                                                        <?php echo e($i); ?>

                                                    </div>
                                                <?php endfor; ?>
                                                <div class="bold text-center">Total.</div>
                                            </div>

                                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $total = 0;
                                                ?>
                                                <div class="flex-column">
                                                    <div>
                                                        <div class="bold text-center"><?php echo e($record->gameType->name); ?></div>
                                                        <?php $__currentLoopData = $record; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $total += $rec->total_amount;
                                                            ?>
                                                            <div class="text-center"><?php echo e($rec->number); ?> =
                                                                <?php echo e($rec->total_amount); ?></div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <div class="bold text-center">
                                                        <?php echo e($total); ?>

                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>

                                    </div>
                                    <button class="btn btn-primary" data-text="<?php echo $dataForClipboard; ?>" id="copyButton">Copy
                                        to
                                        Clipboard</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Add click event listener to the button
            $('#copyButton').click(function() {
                console.log('clicked');
                var textToCopy = $(this).data('text');
                if (!textToCopy) {
                    alert('No data to copy, Please Select Market');
                    return;
                }
                var tempInput = $('<textarea>');
                $('body').append(tempInput);
                tempInput.val(textToCopy);
                tempInput.select();
                document.execCommand('copy');
                tempInput.remove();
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/markets/data.blade.php ENDPATH**/ ?>