<?php $__env->startSection('title', 'Admin | Agents '); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Agents</h4>
                                    <form action="<?php echo e(route('agents.index')); ?>" method="GET" class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                    <div class="card-header-form">
                                        <div class="ml-5 form-group">
                                            <a href="<?php echo e(route('agents.create')); ?>"
                                                class="btn btn-outline-primary">Create</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Invite Code</th>
                                                    <th>Password</th>
                                                    <th>Balance</th>
                                                    <th>Play Percentage</th>
                                                    <th>Blocked | Unblocked</th>
                                                    <th>Action</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($user->id); ?></td>
                                                        <td>
                                                            <a
                                                                href="<?php echo e(route('agents.Detail', $user->id)); ?>"><?php echo e($user->name); ?></a>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo e(route('agents.Detail', $user->id)); ?>">
                                                                <?php if(!env('APP_DEBUG')): ?>
                                                                    <?php echo e($user->phone); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(substr($user->phone, 0, 3) . '****' . substr($user->phone, 7, 10)); ?>

                                                                <?php endif; ?>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="#" class="invite_code">
                                                                <?php echo e(env('AGENT_INVITE_CODE') . $user->own_code); ?>

                                                            </a>
                                                        </td>
                                                        <td><?php echo e($user->password_show); ?></td>
                                                        <td><?php echo e($user->balance); ?></td>
                                                        <td><?php echo e($user->play_percentage); ?></td>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.toogle-blocked.change')): ?>
                                                            <td>
                                                                <div class="mt-3">
                                                                    <div class="selectgroup ">
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio" value="1"
                                                                                name="blocked<?php echo e($user->id); ?>"
                                                                                class="selectgroup-input-radio"
                                                                                <?php if($user->blocked == 1): ?> checked <?php endif; ?>
                                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,1)">
                                                                            <span class="selectgroup-button">Blocked </span>
                                                                        </label>
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio"
                                                                                name="blocked<?php echo e($user->id); ?>"
                                                                                value="0" class="selectgroup-input-radio"
                                                                                <?php if($user->blocked == 0): ?> checked <?php endif; ?>
                                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,0)">
                                                                            <span class="selectgroup-button">Unblock</span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        <?php endif; ?>
                                                        <td>
                                                            <a target="_blank" href="https://wa.me/+91<?php echo e($user->phone); ?>"
                                                                class="btn btn-outline-primary">Open WhatsApp</a>
                                                            
                                                            <?php if(env('ADVANCE_MATKA', 0)): ?>
                                                                <form action="<?php echo e(route('agents.destroy', $user->id)); ?>"
                                                                    method="POST" class="d-inline">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="submit"
                                                                        class="btn btn-outline-danger deleteBtn">Delete</button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo e($user->created_at); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($users->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function toogleBlock(id, block) {
            $.ajax({
                url: "<?php echo e(route('users.toogle-blocked.change')); ?>",
                type: "POST",
                data: {
                    user_id: id,
                    blocked: block
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                        .attr('content')
                },
            });
        }

        $('.invite_code').click(function () {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(this).text()).select();
            document.execCommand("copy");
            $temp.remove();
            Swal.fire({
                icon: 'success',
                title: 'Invite Code Copied',
                showConfirmButton: true,
                timer: false
            });
        });

        $('.deleteBtn').click(function(e) {
            e.preventDefault();
            // show swal
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this record!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $(this).parent().submit();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/agents/index.blade.php ENDPATH**/ ?>