
<?php $__env->startSection('title', 'Agent | Wallet'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.agent_navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="main-content">
                <section class="section">
                    <div class="section-body">
                        <div class="row">
                            <div class="col-12 col-md-6 col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Withdraw Balance</h4>
                                    </div>
                                    <form method="post" action="<?php echo e(route('agent.wallet.withdraw')); ?>">
                                        <?php echo csrf_field(); ?> <div class="card-body">
                                            <div class="form-group">
                                                <label>Payment Method</label>
                                                <div class="input-group">
                                                    <select name="payment_method" class="form-control" id="payment_method">
                                                        <option value="upi">UPI</option>
                                                        <option value="bank" selected>Bank</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Amount</label>
                                                <div class="input-group">
                                                    <input type="number" name="amount" class="form-control"
                                                        value="<?php echo e(old('amount')); ?>"
                                                        min="<?php echo e(env('AGENT_MIN_WITHDRAW', 1)); ?>">
                                                </div>
                                            </div>
                                            <div class="upi-t d-none">
                                                <div class="form-group">
                                                    <label>UPI ID</label>
                                                    <div class="input-group">
                                                        <input type="email" name="upi_id" class="form-control"
                                                            value="<?php echo e(old('upi_id') ?? auth()->user()->withdrawDetails->upi_id); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="bank-t">
                                                <div class="form-group">
                                                    <label>Bank Name</label>
                                                    <div class="input-group">
                                                        <input type="text" name="bank_name" class="form-control"
                                                            value="<?php echo e(old('bank_name')); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Account Holder Name</label>
                                                    <div class="input-group">
                                                        <input type="text" name="account_holder_name"
                                                            class="form-control"
                                                            value="<?php echo e(old('account_holder_name') ?? auth()->user()->withdrawDetails->account_holder_name); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Account Number</label>
                                                    <div class="input-group">
                                                        <input type="number" name="account_number" class="form-control"
                                                            value="<?php echo e(old('account_number') ?? auth()->user()->withdrawDetails->account_number); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Enter IFSC Code</label>
                                                    <div class="input-group">
                                                        <input type="text" name="ifsc_code" class="form-control"
                                                            value="<?php echo e(old('ifsc_code') ?? auth()->user()->withdrawDetails->account_ifsc_code); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <?php if(session('success')): ?>
                                                <div class="alert alert-success">
                                                    <?php echo e(session('success')); ?>

                                                </div>
                                            <?php endif; ?>
                                            <?php if($errors->any()): ?>
                                                <div class="alert alert-danger">
                                                    <ul>
                                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><?php echo e($error); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-outline-primary">Submit</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Balance</h5>
                                                        <h2 class="mb-3 font-18"><?php echo e(auth()->user()->balance); ?></h2>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="<?php echo e(asset('assets/backend/img/banner/4.png')); ?>"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Withdraw History</h4>
                                        <form action="<?php echo e(route('agent.wallet.index')); ?>" method="GET"
                                            class="form-inline mr-auto">
                                            <div class="search-element">
                                                <input name="searchValue" id="myInput" class="form-control"
                                                    <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                    type="search" placeholder="Search" aria-label="Search"
                                                    data-width="200">
                                                <button class="btn" type="submit">
                                                    <i class="fas fa-search"></i>
                                                </button>
                                            </div>
                                        </form>
                                        
                                        <?php if(env('ENABLE_PAYOUT')): ?>
                                            <a href="<?php echo e(route('withdraw.accept-api-all')); ?>"
                                                class="btn btn-outline-primary">SEND
                                                MONEY TO ALL USERS</a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="card-body p-2">
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false"
                                                data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Name</th>
                                                        <th>Phone</th>
                                                        <th>Amount</th>
                                                        <th>Payable Amount</th>
                                                        <th>Request Type</th>
                                                        <th>Withdraw Mode</th>
                                                        <th>UPI Name</th>
                                                        <th>UPI ID</th>
                                                        <th>Bank Name</th>
                                                        <th>Bank Number</th>
                                                        <th>Bank IFSC</th>
                                                        <th>Status</th>
                                                        <th>Created At</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $withdrawHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($withdraw->id); ?></td>
                                                            <td><?php echo e($withdraw->user->name); ?></td>
                                                            <td>
                                                                <a
                                                                    href="<?php echo e(route('users.Detail', $withdraw->user->id)); ?>">
                                                                    <?php if(!env('APP_DEBUG')): ?>
                                                                        <?php echo e($withdraw->user->phone); ?>

                                                                    <?php else: ?>
                                                                        <?php echo e(substr($withdraw->user->phone, 0, 3) . '****' . substr($withdraw->user->phone, 7, 10)); ?>

                                                                    <?php endif; ?>
                                                                </a>
                                                            </td>
                                                            <td><?php echo e($withdraw->amount); ?></td>
                                                            <td><?php echo e($withdraw->payabal_amount); ?></td>
                                                            <td><?php echo e($withdraw->request_type); ?></td>
                                                            <td><?php echo e($withdraw->withdraw_mode); ?></td>
                                                            <td><?php echo e($withdraw->user->withdrawDetails->upi_name); ?></td>
                                                            <td><?php echo e($withdraw->user->withdrawDetails->upi_id); ?></td>
                                                            <td><?php echo e($withdraw->user->withdrawDetails->account_holder_name); ?>

                                                            </td>
                                                            <td><?php echo e($withdraw->user->withdrawDetails->account_number); ?></td>
                                                            <td><?php echo e($withdraw->user->withdrawDetails->account_ifsc_code); ?>

                                                            </td>
                                                            <td class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                                'text-info' => $withdraw->status == 'pending',
                                                                'text-success' => $withdraw->status == 'success',
                                                                'text-danger' => $withdraw->status == 'failed',
                                                            ]); ?>"><?php echo e($withdraw->status); ?></td>
                                                            <td><?php echo e($withdraw->created_at); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="m-2" id="pagination">
                                            <?php echo e($withdrawHistories->links('pagination.custom')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script>
        $(function() {
            $('#payment_method').on('change', function() {
                if ($(this).val() == 'bank') {
                    $('.upi-t').addClass('d-none');
                    $('.bank-t').removeClass('d-none');
                } else {
                    $('.bank-t').addClass('d-none');
                    $('.upi-t').removeClass('d-none');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/agent/wallet/index.blade.php ENDPATH**/ ?>