<?php $__env->startSection('title','Admin | Users '); ?>
<?php $__env->startSection('content'); ?>
<div class="loader"></div>
<div id="app">
    <div class="main-wrapper main-wrapper-1">
        <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Main Content -->
        <div class="main-content">
            <section class="section">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>User Profile</h4>
                            </div>
                            <div class="card-body p-2">
                                <div class="row">
                                    <div class="col-md-6 mb-1">
                                        <div class="col-12 border border-success rounded py-3 px-1">
                                            <h5 class="font-15 px-3">User Details</h5>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <p class="mb-0">User Status</p>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="selectgroup ">
                                                            <label class="selectgroup-item">
                                                                <input type="radio" value="1" name="blocked<?php echo e($user->id); ?>" class="selectgroup-input-radio" <?php if($user->blocked == 1): ?> checked <?php endif; ?>
                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,1)">
                                                                <span style="padding-right: 0.5rem;padding-left: 0.5rem" class="selectgroup-button btn-sm">Blocked </span>
                                                            </label>
                                                            <label class="selectgroup-item">
                                                                <input type="radio" name="blocked<?php echo e($user->id); ?>" value="0" class="selectgroup-input-radio" <?php if($user->blocked == 0): ?> checked <?php endif; ?>
                                                                onchange="toogleBlock(<?php echo e($user->id); ?>,0)">
                                                                <span style="padding-right: 0.5rem;padding-left: 0.5rem" class="selectgroup-button">Unblock</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <p class="mb-0">Wallet Balance</p>
                                                    </div>
                                                    <div class="col-6">
                                                        <p class="mb-0" id="user_wallet_balance"><?php echo e($user->balance); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 flex">
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">Add or Withdraw Points</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-1">
                                        <div class="col-12 border border-success rounded py-3 px-1">
                                            <h5 class="font-15 px-3">Profile Information</h5>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <p class="mb-0">Full Name</p>
                                                    </div>
                                                    <div class="col-6">
                                                        <p id="user_name" class="mb-0"><?php echo e($user->name); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <p class="mb-0">Phone</p>
                                                    </div>
                                                    <div class="col-6">
                                                        <p class="mb-0" id="user_phone"><?php echo e($user->phone); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-6">
                                                        <p class="mb-0">Registered On</p>
                                                    </div>
                                                    <div class="col-6">
                                                        <p class="mb-0" id="user_created_on"><?php echo e($user->created_at); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 mb-1">
                                        <div class="col-12 border border-success rounded py-3 px-1">

                                            <h5 class="font-15 px-3">Payment Information</h5>
                                            <div class="row px-3">
                                                <div class="col-6">
                                                    <p class="mb-0">Account Holder Name</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="mb-0" id="account_name">
                                                        <?php if(isset($user->withdrawDetails->account_holder_name)): ?>
                                                        <?php echo e($user->withdrawDetails->account_holder_name); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="row px-3">
                                                <div class="col-6">
                                                    <p class="mb-0">Account Number</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="mb-0" id="account_number">
                                                        <?php if(isset($user->withdrawDetails->account_number)): ?>
                                                        <?php echo e($user->withdrawDetails->account_number); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="row px-3">
                                                <div class="col-6">
                                                    <p class="mb-0">IFSC Code</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="mb-0" id="ifsc_code">
                                                        <?php if(isset($user->withdrawDetails->account_ifsc_code)): ?>
                                                        <?php echo e($user->withdrawDetails->account_ifsc_code); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="row px-3">
                                                <div class="col-6">
                                                    <p class="mb-0">UPI ID</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="mb-0" id="upi_id">
                                                        <?php if(isset($user->withdrawDetails->upi_id)): ?>
                                                        <?php echo e($user->withdrawDetails->upi_id); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 my-3">
                                        <h5>Withdraw Points Request</h5>
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false" id="myTablee" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>S.No</th>
                                                        <th>Amount</th>
                                                        <th>Request Type</th>
                                                        <th>Date</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(count($withdrawHistory) > 0): ?>
                                                    <?php $__currentLoopData = $withdrawHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($history->id); ?></td>
                                                        <td><?php echo e($history->amount); ?></td>
                                                        <td><?php echo e($history->request_type); ?></td>
                                                        <td><?php echo e($history->created_at); ?></td>
                                                        <td><?php echo e($history->status); ?></td>
                                                        <td>
                                                            <?php if($history->status == "pending"): ?>
                                                            <a href="<?php echo e(url('/withdraw-history/accept-request/'.$history->id)); ?>" class="btn btn-outline-primary">Accept</a>
                                                            <a href="<?php echo e(url('/withdraw-history/reject-request/'.$history->id)); ?>" class="btn btn-outline-primary">Reject</a>
                                                            <?php else: ?>
                                                            No Action
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr class="odd">
                                                        <td colspan="6" class="text-center">No data available</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="col-12 my-3">
                                        <h5>Bid History</h5>
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>S.No</th>
                                                        <th>Game Name</th>
                                                        <th>Game Type</th>
                                                        <th>Digits</th>
                                                        <th>Points</th>
                                                        <th>Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="bid_table">
                                                    <?php if(count($bidHistory) > 0): ?>
                                                    <?php $__currentLoopData = $bidHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($history->id); ?></td>
                                                        <td><?php echo e($history->market->name); ?></td>
                                                        <td><?php echo e($history->gametype->name); ?></td>
                                                        <td><?php echo e($history->number); ?></td>
                                                        <td><?php echo e($history->amount); ?></td>
                                                        <td><?php echo e($history->created_at); ?></td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr class="odd">
                                                        <td colspan="6" class="text-center">No data available</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="col-12 my-3">
                                        <h5>Transactions</h5>
                                        <div class="table-responsive">
                                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                                <li class="nav-item">
                                                    <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">All</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Credit</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Debit</a>
                                                </li>
                                            </ul>
                                            <div class="tab-content" id="myTabContent">
                                                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                                    <div class="table-responsive">
                                                        <table data-searching="false" data-paging="false" data-info="false" class="table table-striped">
                                                            <thead>
                                                                <tr>
                                                                    <th>S.No</th>
                                                                    <th>Points</th>
                                                                    <th>Transaction Note</th>
                                                                    <th>Date</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="all_transactions_table">
                                                                <?php if(count($transactionHistory) > 0): ?>
                                                                <?php $__currentLoopData = $transactionHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($history->id); ?></td>
                                                                    <td><?php echo e($history->amount); ?></td>
                                                                    <td><?php echo e($history->details); ?></td>
                                                                    <td><?php echo e($history->created_at); ?></td>
                                                                </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                <tr class="odd">
                                                                    <td colspan="4" class="text-center">No data available</td>
                                                                </tr>
                                                                <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                                    <div class="table-responsive">
                                                        <table data-searching="false" data-paging="false" data-info="false" class="table table-striped">
                                                            <thead>
                                                                <tr>
                                                                    <th>S.No</th>
                                                                    <th>Points</th>
                                                                    <th>Transaction Note</th>
                                                                    <th>Date</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="all_credits_table">
                                                                <?php if(count($creditHistory) > 0): ?>
                                                                <?php $__currentLoopData = $creditHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($history->id); ?></td>
                                                                    <td><?php echo e($history->amount); ?></td>
                                                                    <td><?php echo e($history->details); ?></td>
                                                                    <td><?php echo e($history->created_at); ?></td>
                                                                </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                <tr class="odd">
                                                                    <td colspan="4" class="text-center">No data available</td>
                                                                </tr>
                                                                <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                                    <div class="table-responsive">
                                                        <table data-searching="false" data-paging="false" data-info="false" class="table table-striped">
                                                            <thead>
                                                                <tr>
                                                                    <th>S.No</th>
                                                                    <th>Points</th>
                                                                    <th>Transaction Note</th>
                                                                    <th>Date</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="all_debit_table">
                                                                <?php if(count($debitHistory) > 0): ?>
                                                                <?php $__currentLoopData = $debitHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($history->id); ?></td>
                                                                    <td><?php echo e($history->amount); ?></td>
                                                                    <td><?php echo e($history->details); ?></td>
                                                                    <td><?php echo e($history->created_at); ?></td>
                                                                </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                <tr class="odd">
                                                                    <td colspan="4" class="text-center">No data available</td>
                                                                </tr>
                                                                <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(!request()->is('users/detail/'.$user->id.'/all')): ?>
                                        <a class="btn btn-info" href='/users/detail/<?php echo e($user->id); ?>/all'>View All</a>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="formModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="formModal">Add | Deduct Balance</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <h4 class="text-success">Balance <?php echo e($user->balance); ?></h4>
                <form method="post" action="<?php echo e(route('users.change-balance.store', ['user' => $user->id])); ?>">
                    <?php echo csrf_field(); ?> <div class="card-body">
                        <div class="form-group">
                            <label>Currency</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        $
                                    </div>
                                </div>
                                <input type="number" min="1" name="balance" class="form-control currency" value="<?php echo e(old('balance')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Choose Action </label>
                            <div class="selectgroup w-100">
                                <label class="selectgroup-item">
                                    <input type="radio" name="action" value="+" class="selectgroup-input-radio" checked>
                                    <span class="selectgroup-button">Add </span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="action" value="-" class="selectgroup-input-radio">
                                    <span class="selectgroup-button">Deduct</span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-outline-primary">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function toogleBlock(id, block) {
        $.ajax({
            url: "<?php echo e(route('users.toogle-blocked.change')); ?>",
            type: "POST",
            data: {
                user_id: id,
                blocked: block
            },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                    .attr('content')
            },
        })
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/users/detail.blade.php ENDPATH**/ ?>