<?php $__env->startSection('title', 'Admin | Withdraw History'); ?>
<?php $__env->startSection('content'); ?>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success">
                                    <?php echo e(session('success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="card">
                                <div class="card-header">
                                    <h4>Withdraw History </h4>
                                    <form action="<?php echo e(route('withdraw-history.index')); ?>" method="GET"
                                        class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                <?php if(isset($searchValue)): ?> value="<?php echo e($searchValue); ?>" <?php endif; ?>
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                    
                                    <?php if(env('ENABLE_PAYOUT')): ?>
                                        <a href="<?php echo e(route('withdraw.accept-api-all')); ?>"
                                            class="btn btn-outline-primary">SEND
                                            MONEY TO ALL USERS</a>
                                    <?php endif; ?>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Amount</th>
                                                    <th>Payable Amount</th>
                                                    <th>Request Type</th>
                                                    <th>Withdraw Mode</th>
                                                    <th>UPI Name</th>
                                                    <th>UPI ID</th>
                                                    <th>Bank Name</th>
                                                    <th>Bank Number</th>
                                                    <th>Bank IFSC</th>
                                                    <th>Status</th>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['withdraw-request-accept', 'withdraw-request-reject'])): ?>
                                                        <th>Action</th>
                                                    <?php endif; ?>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $withdrawHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($withdraw->id); ?></td>
                                                        <td><?php echo e($withdraw->user->name); ?></td>
                                                        <td>
                                                            <a href="<?php echo e(route('users.Detail', $withdraw->user->id)); ?>">
                                                                <?php if(!env('APP_DEBUG')): ?>
                                                                    <?php echo e($withdraw->user->phone); ?>

                                                                <?php else: ?>
                                                                    <?php echo e(substr($withdraw->user->phone, 0, 3) . '****' . substr($withdraw->user->phone, 7, 10)); ?>

                                                                <?php endif; ?>
                                                            </a>
                                                        </td>
                                                        <td><?php echo e($withdraw->amount); ?></td>
                                                        <td><?php echo e($withdraw->payabal_amount); ?></td>
                                                        <td><?php echo e($withdraw->request_type); ?></td>
                                                        <td><?php echo e($withdraw->withdraw_mode); ?></td>
                                                        <td><?php echo e($withdraw->user->withdrawDetails->upi_name); ?></td>
                                                        <td><?php echo e($withdraw->user->withdrawDetails->upi_id); ?></td>
                                                        <td><?php echo e($withdraw->user->withdrawDetails->account_holder_name); ?>

                                                        </td>
                                                        <td><?php echo e($withdraw->user->withdrawDetails->account_number); ?></td>
                                                        <td><?php echo e($withdraw->user->withdrawDetails->account_ifsc_code); ?></td>
                                                        <td class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'text-info' => $withdraw->status == 'pending',
                                                            'text-success' => $withdraw->status == 'success',
                                                            'text-danger' => $withdraw->status == 'failed',
                                                        ]); ?>"><?php echo e($withdraw->status); ?></td>
                                                        <?php if($withdraw->status == 'pending'): ?>
                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['withdraw-request-accept', 'withdraw-request-reject'])): ?>
                                                                <td style="white-space: nowrap;">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-request-accept')): ?>
                                                                        <a href="<?php echo e(route('withdraw-request.accept', ['id' => $withdraw->id])); ?>"
                                                                            class="btn btn-outline-primary">Accept</a>
                                                                        <?php if($withdraw->withdraw_mode == 'bank' && env('ENABLE_PAYOUT')): ?>
                                                                            <a href="<?php echo e(route('withdraw.accept-api', ['id' => $withdraw->id])); ?>"
                                                                                class="btn btn-outline-primary">SEND MONEY USING
                                                                                API</a>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-request-reject')): ?>
                                                                        <a href="<?php echo e(route('withdraw-request.reject', ['id' => $withdraw->id])); ?>"
                                                                            class="btn btn-outline-primary">Reject</a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <td> No Action </td>
                                                        <?php endif; ?>
                                                        <td><?php echo e($withdraw->created_at); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        <?php echo e($withdrawHistories->links('pagination.custom')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/rama555.site/resources/views/dashboard/withdraw-history/index.blade.php ENDPATH**/ ?>