<?php

use App\Http\Controllers\Agent\DashboardController as AgentDashboardController;
use App\Http\Controllers\Agent\PlayHistoryController;
use App\Http\Controllers\Agent\TransactionController as AgentTransactionController;
use App\Http\Controllers\Agent\UserController as AgentUserController;
use App\Http\Controllers\Agent\WalletController;
use App\Http\Controllers\Api\UserController as ApiUserController;
use App\Http\Controllers\Dashboard\AgentController;
use App\Http\Controllers\StartLineChartController;
use App\Http\Controllers\MarketChartController;
use App\Http\Controllers\Dashboard\AppDataController;
use App\Http\Controllers\Dashboard\AuthController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\DepositHistoryController;
use App\Http\Controllers\Dashboard\DesawarMarketController;
use App\Http\Controllers\Dashboard\DesawarRecordController;
use App\Http\Controllers\Dashboard\DesawarResultController;
use App\Http\Controllers\Dashboard\DesawarWinPredictionController;
use App\Http\Controllers\Dashboard\GameTypeController;
use App\Http\Controllers\Dashboard\HomePageController;
use App\Http\Controllers\Dashboard\MarketController;
use App\Http\Controllers\Dashboard\MarketRecordController;
use App\Http\Controllers\Dashboard\MarketResultController;
use App\Http\Controllers\Dashboard\MarketWinPredictionController;
use App\Http\Controllers\Dashboard\NotificationController;
use App\Http\Controllers\Dashboard\ProfitController;
use App\Http\Controllers\Dashboard\SliderImageController;
use App\Http\Controllers\Dashboard\StartLineMarketController;
use App\Http\Controllers\Dashboard\StartLineRecordController;
use App\Http\Controllers\Dashboard\StartLineResultController;
use App\Http\Controllers\Dashboard\StartLineWinPredictionController;
use App\Http\Controllers\Dashboard\SubAdminController;
use App\Http\Controllers\Dashboard\TransactionController;
use App\Http\Controllers\Dashboard\UserController;
use App\Http\Controllers\Dashboard\WithdrawDetailController;
use App\Http\Controllers\Dashboard\WithdrawHistoryController;
use App\Http\Controllers\DesawarChartController;
use App\Http\Controllers\HomeController;
use App\Http\Middleware\CheckAdmin;
use App\Http\Middleware\CheckAgent;
use Google\Service\Batch\AgentContainer;
use Illuminate\Support\Facades\Route;


Route::get('/', [HomeController::class, 'index']);
Route::get('/privacy-policy', [HomeController::class, 'privacy']);
Route::get('/charts', [HomeController::class, 'charts']);
Route::get('/login', [AuthController::class, 'index']);
Route::get('/payment/{user_id}/{amount}', [HomeController::class, 'payment']);
Route::get("/verify-utr/{id}/{utr}/{amount}", [HomeController::class, "verifyUTR"]);
Route::post('/login', [AuthController::class, 'login'])->middleware('throttle:12,1')->name('login');

// Webapp routes
Route::get('/download', [HomeController::class, 'download'])->name('download-apk');
Route::get('/start-line-market/chart/{market}', [StartLineChartController::class, 'index'])->name('start-line-markets.chart');
Route::get('/market/pana-chart/{market}', [MarketChartController::class, 'index'])->name('markets.chart');
Route::get('/market/jodi-chart/{market}', [MarketChartController::class, 'jodiChart'])->name('markets.jodi-chart');
Route::get('/desawar/chart/{market}', [DesawarChartController::class, 'index'])->name('desawar-markets.chart_view');

Route::group(
    [
        'middleware' => [CheckAdmin::class, 'throttle:12,1'],
    ],
    function () {
        Route::middleware(['auth'])->group(function () {
            Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
            Route::post('/getBidsDetail', [DashboardController::class, 'getBidsDetail']);
            Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
            Route::get('/change-password', [AuthController::class, 'changePasswordIndex'])->name('change-password.index');
            Route::post('/change-password', [AuthController::class, 'changePasswordStore'])->name('change-password.store');

            //new routes
            Route::get('/clear-data', [DashboardController::class, 'clearData'])->name('clear.data');

            //common rooute
            Route::post('/records/update', [MarketRecordController::class, 'update'])->name('markets.records.update');

            // Users Routes
            Route::middleware('can:users')->prefix('/users')->group(function () {
                Route::get('/', [UserController::class, 'index'])->name('users.index');
                Route::get('/detail/{id}', [UserController::class, 'getUserDetail'])->name('users.Detail');
                Route::get('/detail/{id}/all', [UserController::class, 'getUserAllDetail'])->name('users.AllDetail');
                Route::get('/create', [UserController::class, 'create'])->name('users.create');
                Route::post('/store', [UserController::class, 'store'])->name('users.store');
                Route::delete('/destroy/{id}', [UserController::class, 'destroy'])->name('users.destroy');
                // Balance
                Route::get('/{user}/change-balance', [UserController::class, 'changeBalanceView'])
                    ->name('users.change-balance.show')->middleware('can:add-deduct-balance-users');
                Route::post('/{user}/change-balance', [UserController::class, 'changeBalance'])
                    ->name('users.change-balance.store')->middleware('can:add-deduct-balance-users');
                Route::post('/toogle-block', [UserController::class, 'toogleBlock'])
                    ->name('users.toogle-blocked.change')->can('users.toogle-blocked.change');
                // withdraw details
                Route::get('/withdraw-details', [WithdrawDetailController::class, 'index'])->name('users.withdraw-details.index');
                Route::get('/withdraw-details/search', [WithdrawDetailController::class, 'search'])->name('users.withdraw-details.search');
            });

            // Agents Routes
            if (env('AGENT_ACTIVE', 0)) {
                Route::middleware('can:agents')->prefix('/agents')->group(function () {
                    Route::get('/', [AgentController::class, 'index'])->name('agents.index');
                    Route::get('/detail/{id}', [AgentController::class, 'getUserDetail'])->name('agents.Detail');
                    Route::get('/detail/{id}/all', [AgentController::class, 'getUserAllDetail'])->name('agents.AllDetail');
                    Route::get('/create', [AgentController::class, 'create'])->name('agents.create');
                    Route::post('/store', [AgentController::class, 'store'])->name('agents.store');
                    Route::delete('/destroy/{id}', [AgentController::class, 'destroy'])->name('agents.destroy');
                    // Balance
                    Route::get('/{user}/change-balance', [AgentController::class, 'changeBalanceView'])->name('agents.change-balance.show')->middleware('can:add-deduct-balance-users');
                    Route::post('/{user}/change-balance', [AgentController::class, 'changeBalance'])->name('agents.change-balance.store')->middleware('can:add-deduct-balance-users');
                    Route::post('/toogle-block', [AgentController::class, 'toogleBlock'])->name('agents.toogle-blocked.change')->can('users.toogle-blocked.change');
                    // withdraw details
                    Route::get('/withdraw-details', [WithdrawDetailController::class, 'index'])->name('agents.withdraw-details.index');
                    Route::get('/withdraw-details/search', [WithdrawDetailController::class, 'search'])->name('agents.withdraw-details.search');
                });
            }

            Route::middleware(['can:markets', 'access-desawar-only'])->group(function () {
                // Markets Routes
                Route::prefix('/markets')->group(function () {
                    Route::get('/', [MarketController::class, 'index'])->name('markets.index');
                    Route::get('/create', [MarketController::class, 'create'])->name('markets.create')->can('create-markets');
                    Route::post('/store', [MarketController::class, 'store'])->name('markets.store')->can('create-markets');
                    Route::get('/{market}/edit', [MarketController::class, 'edit'])->name('markets.edit')->can('edit-markets');
                    Route::put('/{market}/update', [MarketController::class, 'update'])->name('markets.update')->can('update-markets');
                    Route::get('/{market}/destroy', [MarketController::class, 'destroy'])->name('markets.destroy')->can('delete-markets');
                    // Market Results
                    Route::get('/results', [MarketResultController::class, 'index'])->name('markets.results');
                    Route::post('/results', [MarketResultController::class, 'store'])->name('markets.results.store');
                    Route::get('/results/{id}', [MarketResultController::class, 'revert'])->name('markets.results.revert');
                    // Market Results Prediction
                    Route::get('/prediction-results', [MarketWinPredictionController::class, 'index'])->name('markets.prediction-results.index');
                    Route::get('/prediction-results/show', [MarketWinPredictionController::class, 'getPrediction'])
                        ->name('markets.prediction-results.show');
                    Route::post('/prediction-results/updateBid', [MarketWinPredictionController::class, 'updatePredictionBid'])
                        ->name('markets.prediction-results.updateBid');
                    // Market Records
                    Route::get('/records', [MarketRecordController::class, 'index'])->name('markets.records');
                    // Market Win History
                    Route::get('/win-history', [MarketRecordController::class, 'winHistory'])->name('markets.win-history');
                    Route::get('/data', [MarketRecordController::class, 'data'])->name('markets.data');
                });
            });

            Route::middleware(['can:startLine', 'access-desawar-only'])->group(function () {
                // Start Line Markets Routes
                Route::prefix('/start-line-markets')->group(function () {
                    Route::get('/', [StartLineMarketController::class, 'index'])->name('start-line-markets.index');
                    Route::get('/create', [StartLineMarketController::class, 'create'])->name('start-line-markets.create')->can('create-startLine');
                    Route::post('/store', [StartLineMarketController::class, 'store'])->name('start-line-markets.store')->can('create-startLine');
                    Route::get('/{market}/edit', [StartLineMarketController::class, 'edit'])->name('start-line-markets.edit')->can('edit-startLine');
                    Route::put('/{market}/update', [StartLineMarketController::class, 'update'])->name('start-line-markets.update')->can('edit-startLine');
                    Route::get('/{market}/destroy', [StartLineMarketController::class, 'destroy'])->name('start-line-markets.destroy')->can('delete-startLine');
                    // Market Results
                    Route::get('/results', [StartLineResultController::class, 'index'])->name('start-line-markets.results');
                    Route::post('/results', [StartlineResultController::class, 'store'])->name('start-line-markets.results.store');
                    Route::get('/results/{id}', [StartlineResultController::class, 'revert'])->name('start-line-markets.results.revert');
                    // Market Results Prediction
                    Route::get('/prediction-results', [StartLineWinPredictionController::class, 'index'])->name('start-line-markets.prediction-results.index');
                    Route::get('/prediction-results/show', [StartLineWinPredictionController::class, 'getPrediction'])
                        ->name('start-line-markets.prediction-results.show');
                    // Market Records
                    Route::get('/records', [StartLineRecordController::class, 'index'])->name('start-line-markets.records');
                    // Market Win History
                    Route::get('/win-history', [StartLineRecordController::class, 'winHistory'])->name('start-line-markets.win-history');
                });
            });

            // Desawar Markets Routes
            Route::middleware(['can:desawar', 'access-desawar'])->group(function () {
                Route::prefix('/desawar-markets')->group(function () {
                    Route::get('/', [DesawarMarketController::class, 'index'])->name('desawar-markets.index');
                    Route::get('/create', [DesawarMarketController::class, 'create'])->name('desawar-markets.create')->can('create-desawar');
                    Route::post('/store', [DesawarMarketController::class, 'store'])->name('desawar-markets.store')->can('create-desawar');
                    Route::get('/{market}/edit', [DesawarMarketController::class, 'edit'])->name('desawar-markets.edit')->can('edit-desawar');
                    Route::put('/{market}/update', [DesawarMarketController::class, 'update'])->name('desawar-markets.update')->can('edit-desawar');
                    Route::get('/{market}/destroy', [DesawarMarketController::class, 'destroy'])->name('desawar-markets.destroy')->can('delete-desawar');
                    Route::get('/chart', [DesawarMarketController::class, 'chart'])->name('desawar-markets.chart');
                    // Market Results
                    Route::get('/results', [DesawarResultController::class, 'index'])->name('desawar-markets.results');
                    Route::post('/results', [DesawarResultController::class, 'store'])->name('desawar-markets.results.store');
                    Route::get('/results/{id}', [DesawarResultController::class, 'revert'])->name('desawar-markets.results.revert');
                    // Market Results Prediction
                    Route::get('/prediction-results', [DesawarWinPredictionController::class, 'index'])->name('desawar-markets.prediction-results.index');
                    Route::get('/prediction-results/show', [DesawarWinPredictionController::class, 'getPrediction'])
                        ->name('desawar-markets.prediction-results.show');
                    // Market Records
                    Route::get('/records', [DesawarRecordController::class, 'index'])->name('desawar-markets.records');
                    // Market Win History
                    Route::get('/win-history', [DesawarRecordController::class, 'winHistory'])->name('desawar-markets.win-history');
                });
            });

            // App Data
            Route::middleware('can:app-data')->prefix('/app-data')->group(function () {
                Route::get('/', [AppDataController::class, 'index'])->name('app-data.index');
                Route::post('/', [AppDataController::class, 'store'])->name('app-data.store');
            });

            // Profit
            Route::middleware('can:profit')->prefix('/profits')->group(function () {
                Route::get('/', [ProfitController::class, 'index'])->name('profits.index');
            });


            // Game Types
            Route::middleware('can:game-types')->prefix('/game-types')->group(function () {
                Route::get('/', [GameTypeController::class, 'index'])->name('game-types.index');
                Route::post('/{id}', [GameTypeController::class, 'update'])->name('game-types.update')->can('update-game-types');
            });

            // Notifications
            Route::middleware('can:notifications')->prefix('/notifications')->group(function () {
                Route::get('/', [NotificationController::class, 'index'])->name('notifications.index');
                Route::post('/store', [NotificationController::class, 'store'])->name('notifications.store');
            });

            // Transactions
            Route::middleware('can:transactions')->prefix('/transactions')->group(function () {
                Route::get('/', [TransactionController::class, 'index'])->name('transactions.index');
                if (env('AGENT_ACTIVE', 0)) {
                    Route::get('/agent', [TransactionController::class, 'agent'])->name('transactions.agent');
                }
            });

            // Withdraw History
            Route::middleware('can:withdraw-history')->prefix('/withdraw-history')->group(function () {
                Route::get('/', [WithdrawHistoryController::class, 'index'])->name('withdraw-history.index');
                if (env('AGENT_ACTIVE', 0)) {
                    Route::get('/agent', [WithdrawHistoryController::class, 'agent'])->name('withdraw-history.agent');
                }
                Route::get('/accept-request/{id}', [WithdrawHistoryController::class, 'acceptRequest'])->name('withdraw-request.accept')->can('withdraw-request-accept');
                Route::get('/accept-request-api/{id}', [WithdrawHistoryController::class, 'acceptRequestApi'])->name('withdraw.accept-api')->can('withdraw-request-accept');
                Route::get('/accept-request-api-all', [WithdrawHistoryController::class, 'acceptAllRequestApi'])->name('withdraw.accept-api-all')->can('withdraw-request-accept');
                Route::get('/reject-request/{id}', [WithdrawHistoryController::class, 'rejectRequest'])->name('withdraw-request.reject')->can('withdraw-request-reject');
            });

            // Deposit History
            Route::middleware('can:deposit-history')->prefix('/deposit-history')->group(function () {
                Route::get('/', [DepositHistoryController::class, 'index'])->name('deposit-history.index');
                Route::get('/accept-request/{id}', [DepositHistoryController::class, 'acceptRequest'])
                    ->name('deposit-request.accept');
                Route::get('/reject-request/{id}', [DepositHistoryController::class, 'rejectRequest'])
                    ->name('deposit-request.reject');
            });

            // Sub Admins
            Route::middleware('can:sub-admins')->prefix('/sub-admins')->group(function () {
                Route::get('/', [SubAdminController::class, 'index'])->name('sub-admins.index');
                Route::get('/create', [SubAdminController::class, 'create'])->name('sub-admins.create');
                Route::post('/store', [SubAdminController::class, 'store'])->name('sub-admins.store');
                Route::get('/edit/{id}', [SubAdminController::class, 'edit'])->name('sub-admins.edit');
                Route::post('/update/{id}', [SubAdminController::class, 'update'])->name('sub-admins.update');
                Route::get('/delete/{id}', [SubAdminController::class, 'delete'])->name('sub-admins.delete');
                Route::post('/toogle-block', [SubAdminController::class, 'toogleBlock'])
                    ->name('sub-admins.toogle-blocked.change')->can('sub-admins.toogle-blocked.change');
                Route::get('/edit-permissions/{id}', [SubAdminController::class, 'editPermissions'])
                    ->name('sub-admins.edit-permissions');
                Route::post('/update-permissions/{id}', [SubAdminController::class, 'updatePermissions'])
                    ->name('sub-admins.update-permissions');
            });

            // Slider Images
            Route::get('/slider-images', [SliderImageController::class, 'index']);
            Route::post('/slider-images', [SliderImageController::class, 'store'])
                ->name('slider-images.store');
            Route::get('/slider-images/{id}', [SliderImageController::class, 'destroy'])
                ->name('slider-images.destroy');
        });
    }
);


Route::group(
    [
        'prefix' => 'agent',
        'middleware' => ['auth', CheckAgent::class, 'throttle:12,1'],
    ],
    function () {
        Route::get('/dashboard', [AgentDashboardController::class, 'index'])->name('agent.dashboard');
        Route::get('/logout', [AuthController::class, 'logout'])->name('agent.logout');
        Route::get('/change-password', [AgentDashboardController::class, 'changePasswordIndex'])->name('agent.change-password.index');
        Route::post('/change-password', [AgentDashboardController::class, 'changePasswordStore'])->name('agent.change-password.store');

        Route::group(
            [
                'prefix' => 'users',
            ],
            function () {
                Route::get('/', [AgentUserController::class, 'index'])->name('agent.users.index');
            }
        );

        Route::group(
            [
                'prefix' => 'play-history',
            ],
            function () {
                Route::get('/', [PlayHistoryController::class, 'index'])->name('agent.play-history.index');
            }
        );

        Route::group(
            [
                'prefix' => 'wallet',
            ],
            function () {
                Route::get('/', [WalletController::class, 'index'])->name('agent.wallet.index');
                Route::post('withdraw', [WalletController::class, 'withdraw'])->name('agent.wallet.withdraw');
            }
        );
    }
);
