<?php

use App\Http\Controllers\Api\AppDataController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\GameController;
use App\Http\Controllers\Api\MarketController;
use App\Http\Controllers\Api\OtpController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\TransactionController;
use App\Http\Controllers\Api\WithdrawDetailsController;
use App\Http\Controllers\Api\WithdrawHistoryController;
use App\Http\Controllers\Api\DepositHistoryController;
use Illuminate\Support\Facades\Route;


//login signup
Route::post('/login', [AuthController::class, 'login'])->middleware('throttle:12,1');
Route::post('/signup', [AuthController::class, 'create']);

// App data
Route::get('/get-app-data', [AppDataController::class, 'index']);

//forget password
Route::post('/send-forget-password-otp', [AuthController::class, 'forgetPasswordOtp']);
Route::post('/verify-forget-password-otp', [AuthController::class, 'forgetPasswordVerify']);

//transaction
Route::post('/submit-payfromupi-payment', [TransactionController::class, 'SubmitPayFromUpiPayment']);
Route::post('/submit-gateyway-payment', [TransactionController::class, 'SubmitGatewayPayment']);
Route::post('/submit-gateyway-payment-ibr-pay', [TransactionController::class, 'SubmitGatewayPaymentIBRPay']);
Route::post('/submit-gateyway-payment-upi-money', [TransactionController::class, 'SubmitGatewayPaymentUPIMoney']);

// Otp
Route::post('/send-signup-otp', [OtpController::class, 'send']);
Route::post('/verify-signup-otp', [AuthController::class, 'confirm']);

Route::middleware(['auth:sanctum', 'throttle:12,1'])->group(function () {
    // Auth
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/update-profile', [AuthController::class, 'updateProfile']);

    // Market
    Route::post('/get-markets', [MarketController::class, 'index']);

    // User
    Route::post('/change-notification', [UserController::class, 'changeNotification']);
    Route::post('/withdraw-balance', [UserController::class, 'withdrawBalance']);
    Route::get('/get-referral-details', [UserController::class, 'getReferralDetails']);

    // Games
    Route::post('/submit-game', [GameController::class, 'submitGame']);
    Route::post('/get-game-history', [GameController::class, 'getGameHistory']);
    Route::get('/get-game-results', [GameController::class, 'getGameResults']);
    Route::get('/get-game-rates', [GameController::class, 'getGameRates']);

    // Transactions
    Route::post('/pay-from-upi-payment-url', [TransactionController::class, 'RedirectUrlPayFromUpi']);
    Route::post('/get-transactions', [TransactionController::class, 'getTransactions']);
    Route::post('/upi-payment-url', [TransactionController::class, 'RedirectUrl']);
    Route::post('/ibr-pay-upi-payment-url', [TransactionController::class, 'RedirectUrlIBRPay']);
    Route::post('/upi-money-upi-payment-url', [TransactionController::class, 'RedirectUrlUPIMoney']);
    Route::post('/add-payment', [TransactionController::class, 'AddPayment']);

    // Save Withdraw Details
    Route::post('/save-bank-details', [WithdrawDetailsController::class, 'saveBankDetails']);
    Route::post('/save-upi-details', [WithdrawDetailsController::class, 'saveUpiDetails']);

    // Withdraw | Deposit History
    Route::post('/get-deposit-history', [DepositHistoryController::class, 'getDepositHistory']);
    Route::post('/get-withdrawl-history', [WithdrawHistoryController::class, 'getWithdrawlHistory']);

    //get winners list
    Route::get('/get-winners-list', [GameController::class, 'getWinnersList']);
});
