@extends('webapp.layouts.master')

<!-- content start here -->
@section('content')

    <!-- custom css here -->
@section('css')
    <style>
        .date {
            font-size: 9px !important;
            padding: 0 !important;
        }

        .tbb {
            font-weight: bold;
            font-size: 16px !important;
        }

        .tnn {
            font-size: 14px !important;
        }

        .panaChart table {
            table-layout: fixed;
            width: 100%;
        }

        .panaChart th,
        .panaChart td {
            font-size: 12px !important;
        }
    </style>
@stop
<!-- custom css here end -->

<!-- main start  -->
<main>
    <!-- RAJDHANI NIGHT Pana Chart start -->
    <div class="panaChart">
        <div class="container">
            <div class="panaChartTop">
                <h2>{{ $market->name }} Jodi Chart</h2>
            </div>
            <div class="">
                <table class="table table-bordered table-sm text-center">
                    <thead>
                        <tr>
                            <th scope="tdd">Date</th>
                            <th scope="tdd">Mon</th>
                            <th scope="tdd">Tue</th>
                            <th scope="tdd">Wed</th>
                            <th scope="tdd">Thu</th>
                            <th scope="tdd">Fri</th>
                            <th scope="tdd">Sat</th>
                            <th scope="tdd">Sun</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($results as $result)
                            <tr>
                                <td>
                                    <p class="date">{{ $result->start_date }} <br> to <br> {{ $result->end_date }}</p>
                                </td>
                                <td>
                                    <span
                                        class="tbb">{{ $result->monday_open_digit }}{{ $result->monday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->tuesday_open_digit }}
                                        {{ $result->tuesday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->wednesday_open_digit }}
                                        {{ $result->wednesday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->thursday_open_digit }}
                                        {{ $result->thursday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->friday_open_digit }}
                                        {{ $result->friday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->saturday_open_digit }}
                                        {{ $result->saturday_close_digit }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->sunday_open_digit }}
                                        {{ $result->sunday_close_digit }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- RAJDHANI NIGHT Pana Chart end -->

</main>
<!-- main end  -->

@stop
<!-- content end here -->

<!-- js start here -->
@section('script')
@stop
<!-- js end here -->
