@extends('webapp.layouts.master')

<!-- content start here -->
@section('content')

    <!-- custom css here start -->
@section('css')
    <style>
        .date {
            font-size: 9px !important;
            padding: 0 !important;
        }

        .tbb {
            font-weight: bold;
            font-size: 16px !important;
        }

        .tnn {
            font-size: 14px !important;
        }

        .panaChart table {
            table-layout: fixed;
            width: 100%;
        }

        .panaChart th,
        .panaChart td {
            font-size: 12px !important;
        }
    </style>
@stop
<!-- custom css here end -->

<!-- main start  -->
<main>
    <!-- RAJDHANI NIGHT Pana Chart start -->
    <div class="panaChart">
        <div class="container">
            <div class="panaChartTop">
                <h2>{{ $market->name }} </h2>
            </div>
            <div class="">
                <table class="table table-bordered table-sm text-center">
                    <thead>
                        <tr>
                            <th class="tdd">Date</th>
                            <th class="tdd">Mon</th>
                            <th class="tdd">Tue</th>
                            <th class="tdd">Wed</th>
                            <th class="tdd">Thu</th>
                            <th class="tdd">Fri</th>
                            <th class="tdd">Sat</th>
                            <th class="tdd">Sun</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($results as $result)
                            <tr>
                                <td>
                                    <p class="date">{{ $result->start_date }} <br> to <br> {{ $result->end_date }}</p>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->monday_result }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->tuesday_result }} </span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->wednesday_result }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->thursday_result }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->friday_result }}</span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->saturday_result }} </span>
                                </td>
                                <td>
                                    <span class="tbb">{{ $result->sunday_result }}</span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- RAJDHANI NIGHT Pana Chart end -->

</main>
<!-- main end  -->

@stop
<!-- content end here -->
