@extends('layouts.app')
@section('title', 'Admin | Profits')
@section('content')
    @php
        $months = [
            1 => 'January',
            2 => 'February',
            3 => 'March',
            4 => 'April',
            5 => 'May',
            6 => 'June',
            7 => 'July',
            8 => 'August',
            9 => 'September',
            10 => 'October',
            11 => 'November',
            12 => 'December',
        ];
    @endphp
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            @include('layouts.navbar')
            <div class="main-content">
                <section class="section">
                    <div class="section-body">
                        <div class="row">
                            <div class="col-12 col-md-12 col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Profit</h4>
                                    </div>
                                    <div class="card-body row">
                                        <!-- Market Dropdown -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Markets</label>
                                                <select class="form-control" id="market_id" name="market_id">
                                                    <option value="">All</option>
                                                    @foreach ($markets as $market)
                                                        <option value="{{ $market->id }}" @selected(request()->has('type') ? (request()->query('type') === 'market' ? request()->query('market_id') == $market->id : false) : false)>
                                                            {{ $market->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- Date Dropdowns -->
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="market_year" class="form-control">
                                                        @for ($year = date('Y'); $year >= 2000; $year--)
                                                            <option value="{{ $year }}"
                                                                @selected(request()->query('year', 0) == $year)>
                                                                {{ $year }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <select id="market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        @foreach ($months as $key => $value)
                                                            <option value="{{ $key }}"
                                                                @selected(request()->query('month', 0) == $key)>
                                                                {{ $value }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <select id="market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        @for ($day = 1; $day <= 31; $day++)
                                                            <option value="{{ str_pad($day, 2, '0', STR_PAD_LEFT) }}"
                                                                @selected(request()->query('day', 0) == $day)>
                                                                {{ str_pad($day, 2, '0', STR_PAD_LEFT) }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="market_get_button">Get</button>
                                            @if (request()->has('type'))
                                                @if (request()->type == 'market')
                                                    <h5> <span>Total amount: {{ $data['totalBidAmount'] }}</span></h5>
                                                    <h5> <span>Total win amount: {{ $data['totalWinAmount'] }}</span></h5>
                                                    <h5 @class([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ])>

                                                        @if ($data['profit'] == 0)
                                                            <span>Profit: 0 </span>
                                                        @else
                                                            <span @class(['d-none' => $data['profit'] > 0])>Loss: </span>
                                                            <span @class(['d-none' => $data['profit'] < 0])>Profit: </span>
                                                            {{ abs($data['profit']) ?? 0 }}
                                                        @endif
                                                        </h3>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                    <!-- Startline Market Dropdowns -->
                                    <div class="card-body row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Startline Markets</label>
                                                <select class="form-control" id="startline_market_id"
                                                    name="startline_market_id">
                                                    <option value="">All</option>
                                                    @foreach ($startlineMarkets as $market)
                                                        <option value="{{ $market->id }}" @selected(request()->has('type') ? (request()->query('type') === 'startline_market' ? request()->query('market_id') == $market->id : false) : false)>
                                                            {{ $market->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="startline_year" class="form-control">
                                                        @for ($year = date('Y'); $year >= 2000; $year--)
                                                            <option value="{{ $year }}"
                                                                @selected(request()->query('year', 0) == $year)>
                                                                {{ $year }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <select id="startline_market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        @foreach ($months as $key => $value)
                                                            <option value="{{ $key }}"
                                                                @selected(request()->query('month', 0) == $key)>
                                                                {{ $value }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <select id="startline_market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        @for ($day = 1; $day <= 31; $day++)
                                                            <option value="{{ str_pad($day, 2, '0', STR_PAD_LEFT) }}"
                                                                @selected(request()->query('day', 0) == $day)>
                                                                {{ str_pad($day, 2, '0', STR_PAD_LEFT) }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="startline_get_button">Get</button>
                                            @if (request()->has('type'))
                                                @if (request()->type == 'startline_market')
                                                    <h5> <span>Total amount: {{ $data['totalBidAmount'] }}</span></h5>
                                                    <h5> <span>Total win amount: {{ $data['totalWinAmount'] }}</span></h5>
                                                    <h5 @class([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ])>

                                                        @if ($data['profit'] == 0)
                                                            <span>Profit: 0 </span>
                                                        @else
                                                            <span @class(['d-none' => $data['profit'] > 0])>Loss: </span>
                                                            <span @class(['d-none' => $data['profit'] < 0])>Profit: </span>
                                                            {{ abs($data['profit']) ?? 0 }}
                                                        @endif
                                                        </h3>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                    <!-- Desawar Market Dropdowns -->
                                    <div class="card-body row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Desawar Markets</label>
                                                <select class="form-control" id="desawar_market_id"
                                                    name="desawar_market_id">
                                                    <option value="">All</option>
                                                    @foreach ($desawarMarkets as $market)
                                                        <option value="{{ $market->id }}" @selected(request()->has('type') ? (request()->query('type') === 'desawar_market' ? request()->query('market_id') == $market->id : false) : false)>
                                                            {{ $market->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <div class="input-group">
                                                    <select id="desawar_year" class="form-control">
                                                        @for ($year = date('Y'); $year >= 2000; $year--)
                                                            <option value="{{ $year }}"
                                                                @selected(request()->query('year', 0) == $year)>
                                                                {{ $year }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <select id="desawar_market_month" class="form-control">
                                                        <option value="">Select month</option>
                                                        <option value="">None</option>
                                                        @foreach ($months as $key => $value)
                                                            <option value="{{ $key }}"
                                                                @selected(request()->query('month', 0) == $key)>
                                                                {{ $value }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <select id="desawar_market_day" class="form-control">
                                                        <option value="">Select day</option>
                                                        <option value="">None</option>
                                                        @for ($day = 1; $day <= 31; $day++)
                                                            <option value="{{ str_pad($day, 2, '0', STR_PAD_LEFT) }}"
                                                                @selected(request()->query('day', 0) == $day)>
                                                                {{ str_pad($day, 2, '0', STR_PAD_LEFT) }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-flex justify-content-between col-md-12">
                                            <button class="btn btn-primary" id="desawar_get_button">Get</button>
                                            @if (request()->has('type'))
                                                @if (request()->type == 'desawar_market')
                                                    <h5> <span>Total amount: {{ $data['totalBidAmount'] }}</span></h5>
                                                    <h5> <span>Total win amount: {{ $data['totalWinAmount'] }}</span></h5>
                                                    <h5 @class([
                                                        'text-danger' => $data['profit'] < 0,
                                                        'text-success' => $data['profit'] > 0,
                                                    ])>

                                                        @if ($data['profit'] == 0)
                                                            <span>Profit: 0 </span>
                                                        @else
                                                            <span @class(['d-none' => $data['profit'] > 0])>Loss: </span>
                                                            <span @class(['d-none' => $data['profit'] < 0])>Profit: </span>
                                                            {{ abs($data['profit']) ?? 0 }}
                                                        @endif
                                                        </h3>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            function handleGetButton(getButtonSelector, typeSelector, yearSelector, monthSelector, daySelector,
                type) {
                $(getButtonSelector).on('click', function() {
                    let typeId = $(typeSelector).val();
                    let year = $(yearSelector).val();
                    let month = $(monthSelector).val();
                    let day = $(daySelector).val();

                    let url = new URL(window.location.origin + window.location.pathname);
                    url.searchParams.set('type', type);
                    url.searchParams.set('market_id', typeId);
                    url.searchParams.set('year', year);
                    url.searchParams.set('month', month);
                    url.searchParams.set('day', day);

                    window.location.href = url.toString();
                });
            }

            handleGetButton('#market_get_button', '#market_id', '#market_year', '#market_month', '#market_day',
                'market');
            handleGetButton('#startline_get_button', '#startline_market_id', '#startline_year', '#startline_month',
                '#startline_day', 'startline_market');
            handleGetButton('#desawar_get_button', '#desawar_market_id', '#desawar_year', '#desawar_month',
                '#desawar_day', 'desawar_market');
        });
    </script>
@endsection
