@extends('layouts.app')
@section('title', 'Admin | Agents ')
@section('content')
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            @include('layouts.navbar')
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Agents</h4>
                                    <form action="{{ route('agents.index') }}" method="GET" class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                @if (isset($searchValue)) value="{{ $searchValue }}" @endif
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                    <div class="card-header-form">
                                        <div class="ml-5 form-group">
                                            <a href="{{ route('agents.create') }}"
                                                class="btn btn-outline-primary">Create</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Invite Code</th>
                                                    <th>Password</th>
                                                    <th>Balance</th>
                                                    <th>Play Percentage</th>
                                                    <th>Blocked | Unblocked</th>
                                                    <th>Action</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                @foreach ($users as $user)
                                                    <tr>
                                                        <td>{{ $user->id }}</td>
                                                        <td>
                                                            <a
                                                                href="{{ route('agents.Detail', $user->id) }}">{{ $user->name }}</a>
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('agents.Detail', $user->id) }}">
                                                                @if (!env('APP_DEBUG'))
                                                                    {{ $user->phone }}
                                                                @else
                                                                    {{ substr($user->phone, 0, 3) . '****' . substr($user->phone, 7, 10) }}
                                                                @endif
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="#" class="invite_code">
                                                                {{ env('AGENT_INVITE_CODE') . $user->own_code }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $user->password_show }}</td>
                                                        <td>{{ $user->balance }}</td>
                                                        <td>{{ $user->play_percentage }}</td>
                                                        @can('users.toogle-blocked.change')
                                                            <td>
                                                                <div class="mt-3">
                                                                    <div class="selectgroup ">
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio" value="1"
                                                                                name="blocked{{ $user->id }}"
                                                                                class="selectgroup-input-radio"
                                                                                @if ($user->blocked == 1) checked @endif
                                                                                onchange="toogleBlock({{ $user->id }},1)">
                                                                            <span class="selectgroup-button">Blocked </span>
                                                                        </label>
                                                                        <label class="selectgroup-item">
                                                                            <input type="radio"
                                                                                name="blocked{{ $user->id }}"
                                                                                value="0" class="selectgroup-input-radio"
                                                                                @if ($user->blocked == 0) checked @endif
                                                                                onchange="toogleBlock({{ $user->id }},0)">
                                                                            <span class="selectgroup-button">Unblock</span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        @endcan
                                                        <td>
                                                            <a target="_blank" href="https://wa.me/+91{{ $user->phone }}"
                                                                class="btn btn-outline-primary">Open WhatsApp</a>
                                                            {{-- delete user button --}}
                                                            @if (env('ADVANCE_MATKA', 0))
                                                                <form action="{{ route('agents.destroy', $user->id) }}"
                                                                    method="POST" class="d-inline">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit"
                                                                        class="btn btn-outline-danger deleteBtn">Delete</button>
                                                                </form>
                                                            @endif
                                                        </td>
                                                        <td>{{ $user->created_at }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        {{ $users->links('pagination.custom') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function toogleBlock(id, block) {
            $.ajax({
                url: "{{ route('users.toogle-blocked.change') }}",
                type: "POST",
                data: {
                    user_id: id,
                    blocked: block
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                        .attr('content')
                },
            });
        }

        $('.invite_code').click(function () {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(this).text()).select();
            document.execCommand("copy");
            $temp.remove();
            Swal.fire({
                icon: 'success',
                title: 'Invite Code Copied',
                showConfirmButton: true,
                timer: false
            });
        });

        $('.deleteBtn').click(function(e) {
            e.preventDefault();
            // show swal
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this record!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $(this).parent().submit();
                }
            });
        });
    </script>
@endsection
