@extends('layouts.app')
@section('title', 'Agent | Wallet')
@section('content')
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            @include('layouts.agent_navbar')
            <div class="main-content">
                <section class="section">
                    <div class="section-body">
                        <div class="row">
                            <div class="col-12 col-md-6 col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Withdraw Balance</h4>
                                    </div>
                                    <form method="post" action="{{ route('agent.wallet.withdraw') }}">
                                        @csrf <div class="card-body">
                                            <div class="form-group">
                                                <label>Payment Method</label>
                                                <div class="input-group">
                                                    <select name="payment_method" class="form-control" id="payment_method">
                                                        <option value="upi">UPI</option>
                                                        <option value="bank" selected>Bank</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label>Amount</label>
                                                <div class="input-group">
                                                    <input type="number" name="amount" class="form-control"
                                                        value="{{ old('amount') }}"
                                                        min="{{ env('AGENT_MIN_WITHDRAW', 1) }}">
                                                </div>
                                            </div>
                                            <div class="upi-t d-none">
                                                <div class="form-group">
                                                    <label>UPI ID</label>
                                                    <div class="input-group">
                                                        <input type="email" name="upi_id" class="form-control"
                                                            value="{{ old('upi_id') ?? auth()->user()->withdrawDetails->upi_id }}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="bank-t">
                                                <div class="form-group">
                                                    <label>Bank Name</label>
                                                    <div class="input-group">
                                                        <input type="text" name="bank_name" class="form-control"
                                                            value="{{ old('bank_name') }}">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Account Holder Name</label>
                                                    <div class="input-group">
                                                        <input type="text" name="account_holder_name"
                                                            class="form-control"
                                                            value="{{ old('account_holder_name') ?? auth()->user()->withdrawDetails->account_holder_name }}">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Account Number</label>
                                                    <div class="input-group">
                                                        <input type="number" name="account_number" class="form-control"
                                                            value="{{ old('account_number') ?? auth()->user()->withdrawDetails->account_number }}">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label>Enter IFSC Code</label>
                                                    <div class="input-group">
                                                        <input type="text" name="ifsc_code" class="form-control"
                                                            value="{{ old('ifsc_code') ?? auth()->user()->withdrawDetails->account_ifsc_code }}">
                                                    </div>
                                                </div>
                                            </div>
                                            @if (session('success'))
                                                <div class="alert alert-success">
                                                    {{ session('success') }}
                                                </div>
                                            @endif
                                            @if ($errors->any())
                                                <div class="alert alert-danger">
                                                    <ul>
                                                        @foreach ($errors->all() as $error)
                                                            <li>{{ $error }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-outline-primary">Submit</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Balance</h5>
                                                        <h2 class="mb-3 font-18">{{ auth()->user()->balance }}</h2>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Withdraw History</h4>
                                        <form action="{{ route('agent.wallet.index') }}" method="GET"
                                            class="form-inline mr-auto">
                                            <div class="search-element">
                                                <input name="searchValue" id="myInput" class="form-control"
                                                    @if (isset($searchValue)) value="{{ $searchValue }}" @endif
                                                    type="search" placeholder="Search" aria-label="Search"
                                                    data-width="200">
                                                <button class="btn" type="submit">
                                                    <i class="fas fa-search"></i>
                                                </button>
                                            </div>
                                        </form>
                                        {{-- withdraw.accept-api-all call a href --}}
                                        @if (env('ENABLE_PAYOUT'))
                                            <a href="{{ route('withdraw.accept-api-all') }}"
                                                class="btn btn-outline-primary">SEND
                                                MONEY TO ALL USERS</a>
                                        @endif
                                    </div>
                                    <div class="card-body p-2">
                                        <div class="table-responsive">
                                            <table data-searching="false" data-paging="false" data-info="false"
                                                data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Name</th>
                                                        <th>Phone</th>
                                                        <th>Amount</th>
                                                        <th>Payable Amount</th>
                                                        <th>Request Type</th>
                                                        <th>Withdraw Mode</th>
                                                        <th>UPI Name</th>
                                                        <th>UPI ID</th>
                                                        <th>Bank Name</th>
                                                        <th>Bank Number</th>
                                                        <th>Bank IFSC</th>
                                                        <th>Status</th>
                                                        <th>Created At</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($withdrawHistories as $withdraw)
                                                        <tr>
                                                            <td>{{ $withdraw->id }}</td>
                                                            <td>{{ $withdraw->user->name }}</td>
                                                            <td>
                                                                <a
                                                                    href="{{ route('users.Detail', $withdraw->user->id) }}">
                                                                    @if (!env('APP_DEBUG'))
                                                                        {{ $withdraw->user->phone }}
                                                                    @else
                                                                        {{ substr($withdraw->user->phone, 0, 3) . '****' . substr($withdraw->user->phone, 7, 10) }}
                                                                    @endif
                                                                </a>
                                                            </td>
                                                            <td>{{ $withdraw->amount }}</td>
                                                            <td>{{ $withdraw->payabal_amount }}</td>
                                                            <td>{{ $withdraw->request_type }}</td>
                                                            <td>{{ $withdraw->withdraw_mode }}</td>
                                                            <td>{{ $withdraw->user->withdrawDetails->upi_name }}</td>
                                                            <td>{{ $withdraw->user->withdrawDetails->upi_id }}</td>
                                                            <td>{{ $withdraw->user->withdrawDetails->account_holder_name }}
                                                            </td>
                                                            <td>{{ $withdraw->user->withdrawDetails->account_number }}</td>
                                                            <td>{{ $withdraw->user->withdrawDetails->account_ifsc_code }}
                                                            </td>
                                                            <td @class([
                                                                'text-info' => $withdraw->status == 'pending',
                                                                'text-success' => $withdraw->status == 'success',
                                                                'text-danger' => $withdraw->status == 'failed',
                                                            ])>{{ $withdraw->status }}</td>
                                                            <td>{{ $withdraw->created_at }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="m-2" id="pagination">
                                            {{ $withdrawHistories->links('pagination.custom') }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <script>
        $(function() {
            $('#payment_method').on('change', function() {
                if ($(this).val() == 'bank') {
                    $('.upi-t').addClass('d-none');
                    $('.bank-t').removeClass('d-none');
                } else {
                    $('.bank-t').addClass('d-none');
                    $('.upi-t').removeClass('d-none');
                }
            });
        });
    </script>
@endsection
