@extends('layouts.app')
@section('title', 'Agent | Users ')
@section('content')
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            @include('layouts.agent_navbar')
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4>Users</h4>
                                    <form action="{{ route('agent.users.index') }}" method="GET"
                                        class="form-inline mr-auto">
                                        <div class="search-element">
                                            <input name="searchValue" id="myInput" class="form-control"
                                                @if (isset($searchValue)) value="{{ $searchValue }}" @endif
                                                type="search" placeholder="Search" aria-label="Search" data-width="200">
                                            <button class="btn" type="submit">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Balance</th>
                                                    <th>Total Game Amount</th>
                                                    <th>Total Won</th>
                                                    <th>Total Withdraw</th>
                                                    <th>Total Bonus</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                @foreach ($users as $user)
                                                    <tr>
                                                        <td>{{ $user->id }}</td>
                                                        <td>
                                                            {{ $user->name }}
                                                        </td>
                                                        <td>
                                                            {{ substr($user->phone, 0, 7) }}****
                                                        </td>
                                                        <td>{{ $user->balance }}</td>
                                                        <td>
                                                            {{ $user->total_market_game_amount + $user->total_startLine_game_amount + $user->total_desawar_game_amount ??
                                                                'no games yet' }}
                                                        </td>
                                                        <td>
                                                            {{ $user->total_market_win_amount + $user->total_startline_win_amount + $user->total_desawar_win_amount }}
                                                        </td>
                                                        <td>
                                                            {{ $user->total_withdraw_success_amount }}
                                                        </td>
                                                        <td>{{ $user->bonus }}</td>
                                                        <td>{{ $user->created_at }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        {{ $users->links('pagination.custom') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
@endsection
