@extends('layouts.app')
@section('title', 'Agent | Play History ')
@section('content')
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            @include('layouts.agent_navbar')
            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="row">
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="card">
                                <div class="card-statistic-4">
                                    <div class="align-items-center justify-content-between">
                                        <div class="row ">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                <div class="card-content">
                                                    <h5 class="font-15">Total Play Today</h5>
                                                    <h2 class="mb-3 font-18">{{ $users->sum('total_game_amount_today') }}
                                                    </h2>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                <div class="banner-img">
                                                    <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="card">
                                <div class="card-statistic-4">
                                    <div class="align-items-center justify-content-between">
                                        <div class="row ">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                <div class="card-content">
                                                    <h5 class="font-15">Total Win Today</h5>
                                                    <h2 class="mb-3 font-18">{{ $users->sum('total_win_amount_today') }}
                                                    </h2>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                <div class="banner-img">
                                                    <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="card">
                                <div class="card-statistic-4">
                                    <div class="align-items-center justify-content-between">
                                        <div class="row ">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                <div class="card-content">
                                                    <h5 class="font-15">Total Commission Today</h5>
                                                    <h2 class="mb-3 font-18">{{ $users->sum('agent_commission') }}</h2>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                <div class="banner-img">
                                                    <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="card">
                                <div class="card-statistic-4">
                                    <div class="align-items-center justify-content-between">
                                        <div class="row ">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                <div class="card-content">
                                                    <h5 class="font-15">Total Deposit Today</h5>
                                                    <h2 class="mb-3 font-18">
                                                        {{ $users->sum('total_deposit_success_amount_today') }}</h2>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                <div class="banner-img">
                                                    <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="card">
                                <div class="card-statistic-4">
                                    <div class="align-items-center justify-content-between">
                                        <div class="row ">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                <div class="card-content">
                                                    <h5 class="font-15">Total Withdraw Today</h5>
                                                    <h2 class="mb-3 font-18">
                                                        {{ $users->sum('total_withdraw_success_amount_today') }}</h2>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                <div class="banner-img">
                                                    <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div>
                                            <h4>Play History</h4>
                                            <form action="{{ route('agent.play-history.index') }}" method="GET"
                                                class="form-inline mr-auto">
                                                <div class="search-element">
                                                    <input name="searchValue" id="myInput" class="form-control"
                                                        @if (isset($searchValue)) value="{{ $searchValue }}" @endif
                                                        type="search" placeholder="Search" aria-label="Search"
                                                        data-width="200">
                                                    <button class="btn" type="submit">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                        <div>
                                            <h4>Search By Date</h4>
                                            <form action="{{ route('agent.play-history.index') }}" method="GET"
                                                class="form-inline mr-auto">
                                                <div class="search-element">
                                                    <input name="searchValueDate" id="myInput" class="form-control"
                                                        @if (isset($searchValueDate)) value="{{ $searchValueDate }}" @endif
                                                        type="date" placeholder="Search" aria-label="Search"
                                                        data-width="200">
                                                    <button class="btn" type="submit">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table data-searching="false" data-paging="false" data-info="false"
                                            data-order='[[ 0, "desc" ]]' id="myTable" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Name</th>
                                                    <th>Phone</th>
                                                    <th>Balance</th>
                                                    <th>Total Play Today</th>
                                                    <th>Total Won Today</th>
                                                    <th>Withdraw Today</th>
                                                    <th>Deposit Today</th>
                                                    <th>Total Commission</th>
                                                    <th>Created At</th>
                                                </tr>
                                            </thead>
                                            <tbody id="table-body">
                                                @foreach ($users as $user)
                                                    <tr>
                                                        <td>{{ $user->id }}</td>
                                                        <td>{{ $user->name }} </td>
                                                        <td>{{ substr($user->phone, 0, 7) }}****</td>
                                                        <td>{{ $user->balance }}</td>
                                                        <td>
                                                            {{ $user->total_game_amount_today ?? 0 }}
                                                        </td>
                                                        <td>
                                                            {{ $user->total_win_amount_today ?? 0 }}
                                                        </td>
                                                        <td>
                                                            {{ $user->total_withdraw_success_amount_today ?? 0 }}
                                                        </td>
                                                        <td>
                                                            {{ $user->total_deposit_success_amount_today ?? 0 }}
                                                        </td>
                                                        <td>{{ $user->agent_commission }}</td>
                                                        <td>{{ $user->created_at }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="m-2" id="pagination">
                                        {{ $users->links('pagination.custom') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
@endsection
