@extends('layouts.app')

@section('content')
    <div>
        <div class="loader"></div>
        <div id="app">
            <div class="main-wrapper main-wrapper-1">
                @include('layouts.agent_navbar')
                <!-- Main Content -->
                <div class="main-content">
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <section class="section">
                        <div class="row">
                            <div class="col-12 d-flex">
                                <div class="card d-flex">
                                    <div class="card-body">
                                        <div class="d-flex mb-4 justify-content-between align-items-center">
                                            <h6>Invite Code</h6>
                                            <button class="invite_code btn btn-sm btn-primary">
                                                Copy
                                            </button>
                                        </div>
                                        <a href="#" class="invite_code">{{ env('AGENT_INVITE_CODE') . auth()->user()->own_code }}</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Commission Percentage</h5>
                                                        <h2 class="mb-3 font-18">{{ auth()->user()->play_percentage }}%</h2>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Today Win</h5>
                                                        <h2 class="mb-3 font-18">{{ $today_win }}</h2>
                                                        <p class="mb-0"><span class="col-green">{{ $month_win }}</span>
                                                            Win This Month</p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Today Play</h5>
                                                        <h2 class="mb-3 font-18">{{ $today_play }}</h2>
                                                        <p class="mb-0"><span class="col-green">{{ $month_play }}</span>
                                                            Play This Month</p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Today Commission</h5>
                                                        <h2 class="mb-3 font-18">{{ $commission_today }}</h2>
                                                        <p class="mb-0"><span
                                                                class="col-green">{{ $commission_month }}</span>
                                                            Commission This Month</p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Today Withdraw</h5>
                                                        <h2 class="mb-3 font-18">{{ $withdraw_today }}</h2>
                                                        <p class="mb-0"><span
                                                                class="col-green">{{ $withdraw_month }}</span>
                                                            Withdraw This Month</p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="card">
                                    <div class="card-statistic-4">
                                        <div class="align-items-center justify-content-between">
                                            <div class="row ">
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                                                    <div class="card-content">
                                                        <h5 class="font-15">Today Recharge</h5>
                                                        <h2 class="mb-3 font-18">{{ $recharge_today }}</h2>
                                                        <p class="mb-0"><span
                                                                class="col-green">{{ $recharge_month }}</span>
                                                            Recharge This Month</p>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                                                    <div class="banner-img">
                                                        <img src="{{ asset('assets/backend/img/banner/4.png') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $('.invite_code').click(function () {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(
                "{{ env('AGENT_INVITE_CODE') . auth()->user()->own_code }}"
            ).select();
            document.execCommand("copy");
            $temp.remove();
            Swal.fire({
                icon: 'success',
                title: 'Invite Code Copied',
                showConfirmButton: true,
                timer: false
            });
        });
    </script>
@endsection
