<?php

namespace Database\Seeders;

use App\Models\AppData;
use App\Models\DepositHistory;
use App\Models\DesawarMarket;
use App\Models\DesawarRecord;
use App\Models\DesawarResult;
use App\Models\Notification;
use App\Models\Transaction;
use App\Models\User;
use App\Models\WithdrawDetail;
use App\Models\WithdrawHistory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //$2y$10$w20UQirncBX7NOT7iWT83ux4Hm0uD5hAVhoLfF/vk4kdahB.qJna6
        // admin
        User::create([
            'name' => 'Test User',
            'phone' => '1234567890',
            'password' => Hash::make('1234'),
            'role' => 'user',
            'confirmed' => 1,
        ]);
        // user
        $value = rand(1000, 9999);
        $password = Hash::make($value);
        User::create([
            'id' => '2',
            'name' => 'Admin',
            'phone' => '1234567899',
            'password' => $password,
            'password_show' => $value,
            'role' => 'admin',
            'confirmed' => 1,
        ]);
        User::create([
            'id' => '3',
            'name' => 'Test User',
            'phone' => '8376944575',
            'password' => Hash::make('1234'),
            'role' => 'user',
            'confirmed' => 1,
        ]);
        // sub-admin
        // User::create([
        //     'id' => '3',
        //     'name' => 'Alexa',
        //     'phone' => '1234567999',
        //     'password' => Hash::make('1234'),
        //     'role' => 'sub-admin',
        //     'confirmed' => 1,
        // ]);
    }
}
