<?php

namespace Database\Seeders;

use App\Models\AppData;
use App\Models\GameType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use function PHPSTORM_META\type;

class GameTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Single Digit - General
        GameType::create([
            'name' => 'Single Digit',
            'game_type' => 'single_digit',
            'multiply_by' => 9.5,
            'type' => 'general'
        ]);

        // Jodi Digit - General
        GameType::create([
            'name' => 'Jodi Digit',
            'game_type' => 'jodi_digit',
            'multiply_by' => 95,
            'type' => 'general'
        ]);

        // Single Pana - General
        GameType::create([
            'name' => 'Single Pana',
            'game_type' => 'single_pana',
            'multiply_by' => 150,
            'type' => 'general'
        ]);

        // Double Pana - General
        GameType::create([
            'name' => 'Double Pana',
            'game_type' => 'double_pana',
            'multiply_by' => 300,
            'type' => 'general'
        ]);

        // Triple Pana - General
        GameType::create([
            'name' => 'Triple Pana',
            'game_type' => 'triple_pana',
            'multiply_by' => 900,
            'type' => 'general'
        ]);

        // Half Sangam A - General
        GameType::create([
            'name' => 'Half Sangam A',
            'game_type' => 'half_sangam_a',
            'multiply_by' => 1000,
            'type' => 'general'
        ]);

        // Half Sangam B - General
        GameType::create([
            'name' => 'Half Sangam B',
            'game_type' => 'half_sangam_b',
            'multiply_by' => 1000,
            'type' => 'general'
        ]);

        // Full Sangam - General
        GameType::create([
            'name' => 'Full Sangam',
            'game_type' => 'full_sangam',
            'multiply_by' => 10000,
            'type' => 'general'
        ]);

        // Single Digit - Start_line
        GameType::create([
            'name' => 'Single Digit',
            'game_type' => 'single_digit',
            'multiply_by' => 10,
            'type' => 'start_line'
        ]);

        // Single Pana - Start_line
        GameType::create([
            'name' => 'Single Pana',
            'game_type' => 'single_pana',
            'multiply_by' => 160,
            'type' => 'start_line'
        ]);

        // Double Pana - Start_line
        GameType::create([
            'name' => 'Double Pana',
            'game_type' => 'double_pana',
            'multiply_by' => 320,
            'type' => 'start_line'
        ]);

        // Triple Pana - Start_line
        GameType::create([
            'name' => 'Triple Pana',
            'game_type' => 'triple_pana',
            'multiply_by' => 1000,
            'type' => 'start_line'
        ]);

        // Jodi - Desawar
        GameType::create([
            'name' => 'Jodi',
            'game_type' => 'jodi',
            'multiply_by' => 90,
            'type' => 'desawar'
        ]);

        // Andar - Desawar
        GameType::create([
            'name' => 'Andar',
            'game_type' => 'andar',
            'multiply_by' => 9,
            'type' => 'desawar'
        ]);
        // Bahar - Desawar
        GameType::create([
            'name' => 'Bahar',
            'game_type' => 'bahar',
            'multiply_by' => 9,
            'type' => 'desawar'
        ]);
    }
}
