<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['user', 'admin', 'sub-admin', 'agent'])->change();
            $table->decimal('play_percentage')->nullable();
            $table->string('own_code')->default('0')->change();
            $table->timestamp('last_users_view')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['user', 'admin', 'sub-admin'])->change();
            $table->dropColumn('play_percentage');
            $table->string('own_code')->default('0')->change();
            $table->dropColumn('last_users_view');
        });
    }
};
