<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('desawar_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('desawar_market_id')->constrained();
            $table->date('result_date');
            $table->string('result')->nullable()->default(NULL);
            $table->string('first_digit_of_result')->nullable()->default(NULL);
            $table->string('second_digit_of_result')->nullable()->default(NULL);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('desawar_results');
    }
};
