<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('desawar_markets', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('api_key_name');
            $table->boolean('auto_result')->default(0);
            $table->boolean('previous_day_check')->default(0);
            $table->boolean('disable_game')->default(0);
            $table->time('open_time');
            $table->time('close_time');
            $table->time('result_time');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('desawar_markets');
    }
};
