<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_data', function (Blueprint $table) {
            $table->id();
            $table->boolean('maintain_mode')->default(false);

            $table->integer('version')->default(1);
            $table->string('home_message')->default('Welcome to ' . env('APP_NAME') . '. India"s Best Matka App for online Gaming.');
            $table->string('support_number')->default('+91 1234567890');
            $table->string('support_time')->default('10:00 AM - 10:00 PM');
            $table->integer('min_bid_amount')->default(5);
            $table->integer('max_bid_amount')->default(5000);
            $table->integer('min_withdraw')->default(1000);
            $table->integer('min_deposit')->default(500);
            $table->float('self_recharge_bonus')->default(0);
            $table->float('invite_bonus_1st_time')->default(0);
            $table->float('invite_bonus_2nd_time')->default(0);
            $table->boolean('invite_system_enable')->default(true);
            $table->integer('welcome_bonus')->default(0);
            $table->string('admin_upi')->default('upi@ybl');
            $table->boolean('telegram_enable')->default(true);
            $table->string('telegram_link')->nullable()->default('https://www.t.me/telegram_id');
            $table->boolean('whatsapp_enable')->default(false);
            $table->string('whatsapp_number')->nullable()->default(NULL);
            $table->time('withdraw_open_time')->default('10:00:00');
            $table->time('withdraw_close_time')->default('22:00:00');
            $table->enum('payment_method', ['auto', 'manual', 'direct_upi', 'ibr_pay', 'upi_money', 'pay_from_upi'])->default('direct_upi');
            $table->string('payfromupi_api_key')->nullable()->default(NULL);
            $table->string('auto_result_api')->nullable()->default(NULL);
            $table->string('sms_api_key')->nullable()->default(NULL);
            $table->string('app_update_link')->nullable()->default(env('APP_URL') . '/download');
            $table->boolean('bank_withdraw_enable')->default(true);
            $table->boolean('upi_withdraw_enable')->default(true);
            $table->boolean('enable_desawar')->default(true);
            $table->boolean('enable_desawar_only')->default(false);
            $table->string("fcm_key", 512)->nullable()->default(NULL);
            $table->string("homepage_image_url")->nullable()->default(NULL);
            $table->string("slider_url")->nullable()->default(NULL);
            $table->string("upi_image")->nullable()->default(NULL);
            $table->string("upi_gateway_key")->nullable()->default(NULL);
            $table->boolean('play_store')->default(false);
            $table->boolean('show_results_only')->default(false);
            $table->float('total_mannual_amount_added', 8, 2)->default(0);
            $table->float('withdrawal_fee')->nullable()->default(NULL);

            $table->string('new_matka_api_token')->nullable()->default(NULL);

            //long datas
            $table->longText('withdrawal_condition')->nullable()->default('<p>👍 Minimum Withdraw is 1000/- Rs.</p><p>👍 Maximum Withdraw Is 50,000/- Rs.</p><p>👍 Above 50k You Should Request Us Manually.</p><p>👍 Withdraw Request Timing is 10:00 AM to 10:00 PM.</p><p>👍 Process Time is 12-24 Hours</p><p>👍 Withdraw Is Available On All Days Except National Holidays</p>');
            $table->longText('rules_notice')->nullable()->default('<p><span class="ql-size-large">Withdraw Information</span></p><p>👍&nbsp;If Users Entered Wrong Bank Details We Are Not Responsible</p><p>👍&nbsp;Before Requesting Withdraw Re-check Your Bank Details</p><p>👍&nbsp;After Withdraw Request If There is No Valid Wallet Balance The Request Will Be Auth Declines.</p><p><br></p><p><span style="color: rgb(33, 37, 41);" class="ql-size-large">Unfair - Bets</span></p><p>If Admin Found Any Unfaid-bets, Blocking Of Digits, Canning Or Match Fix Bets. Admin Has All Rights To Take Necessary Actions To Block The User.</p><p><br></p><p><span class="ql-size-large">Cheating - Bets</span></p><p>If Admin Found Any Cheating, Hacking Phishing. Admin Has All Rights To Take Necessary Actions To Block The User.</p>');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_data');
    }
};
