<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('phone')->unique();
            $table->string('password');
            $table->string('password_show')->nullable()->default(NULL);
            $table->integer('balance')->default(0);
            $table->boolean('general_noti')->default(1);
            $table->boolean('startline_noti')->default(1);
            $table->boolean('desawar_noti')->default(1);
            $table->text('fcm')->nullable()->default(NULL);
            $table->integer('own_code')->default(0);
            $table->integer('bonus')->default(0);
            $table->foreignId('user_id')->nullable()->default(NULL)->constrained();
            $table->boolean('blocked')->default(false);
            $table->timestamp('last_logged_id')->default(now());
            $table->enum('role', ['user', 'admin', 'sub-admin']);
            $table->boolean('confirmed')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
