<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DesawarRecord>
 */
class DesawarRecordFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'desawar_market_id' => 1,
            'user_id' => 1,
            'game_type_id' => 1,
            'number' => $this->faker->numberBetween(0, 99),
            'amount' => $this->faker->numberBetween(100, 1000),
            'game_string' => 'abcdefghi',
            'win_amount' => $this->faker->numberBetween(100, 10000),
            'date' => now(),
            // 'date' => $this->faker->dateTimeBetween('-1 week', 'now')->format('Y-m-d'),
            'status' => $this->faker->randomElement(['pending', 'success', 'failed']),
        ];
    }
}
