<?php

namespace App\Notifications;

use App\Http\Controllers\Dashboard\NotificationController;
use App\Models\AppData;
use GuzzleHttp\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class WithdrawRequestAcceptNotification extends Notification
{
    use Queueable;
    protected $amount;
    protected $fcm;

    public function __construct($amount, $fcm)
    {
        $this->amount = $amount;
        $this->fcm = $fcm;
    }

    public function via()
    {
        return $this->toFcm();
    }


    public function toFcm()
    {
        $notificationController = new NotificationController();
        $client = $notificationController->getFirebaseClientUrl();
        if ($client == NULL) {
            return;
        }

        try {
            $response = $client->post(env('FIREBASE_URL'), [
                'json' => [
                    'message' => [
                        'token' => "$this->fcm",
                        // 'topic' => 'daily_messaging_all_users',
                        'notification' => [
                            'body' => 'Your withdrawal of ₹' . $this->amount . ' has been Approved',
                            'title' => 'Withdraw Request Accepted',
                        ],
                        // 'data' => [
                        //     'message' => '₹' . $this->amount,
                        //     'title' => 'Withdraw Approved',
                        // ],
                    ],
                ],
            ]);
            $body = $response->getBody();
        } catch (\Throwable $th) {
        }
    }
}
