<?php

namespace App\Notifications;

use App\Http\Controllers\Dashboard\NotificationController;
use App\Models\AppData;
use GuzzleHttp\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;

class GameWinNotification extends Notification
{
    use Queueable;

    protected $amount;
    protected $fcm;

    public function __construct($amount, $fcm)
    {
        $this->amount = $amount;
        $this->fcm = $fcm;
    }

    public function via()
    {
        return $this->toFcm();
    }


    public function toFcm()
    {
        $notificationController = new NotificationController();
        $client = $notificationController->getFirebaseClientUrl();
        if ($client == NULL) {
            return;
        }

        try {
            $response = $client->post(env('FIREBASE_URL'), [
                'json' => [
                    'message' => [
                        'token' => "$this->fcm",
                        // 'topic' => 'daily_messaging_all_users',
                        'notification' => [
                            'body' => 'You won game and amount is ₹' . $this->amount,
                            'title' => 'Game Win',
                        ],
                        // 'data' => [
                        //     'message' => '₹' . $this->amount,
                        //     'title' => 'GAME WIN',
                        // ],
                    ],
                ],
            ]);
            $body = $response->getBody();
        } catch (\Throwable $th) {
        }
    }
}
