<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'previous_amount',
        'amount',
        'current_amount',
        'type',
        'details'
    ];

    //market record
    public function marketRecord()
    {
        return $this->hasOne(MarketRecord::class);
    }

    //desawar record
    public function desawarRecord()
    {
        return $this->hasOne(DesawarRecord::class);
    }

    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('m/d/Y h:i A');
    }

    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('m/d/Y h:i A');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
