<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class DesawarMarket extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'api_key_name',
        'previous_day_check',
        'open_time',
        'auto_result',
        'close_time',
        'result_time',
        'disable_game'
    ];

    protected $appends = ['game_on', 'last_result'];

    public function getLastResultAttribute()
    {
        $last_result = $this->results()->latest()->first();
        if ($last_result !== NULL && $last_result->result_date == date('Y-m-d')) {
            return $last_result;
        }
        return NULL;
    }

    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('m/d/Y h:i A');
    }

    public function getOpenTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function getCloseTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function getResultTimeAttribute($value)
    {
        return Carbon::parse($value)->format('h:i A');
    }

    public function records()
    {
        return  $this->hasMany(DesawarRecord::class);
    }

    public function results()
    {
        return $this->hasMany(DesawarResult::class);
    }

    public function getGameOnAttribute()
    {
        if ($this->disable_game) {
            return false;
        }
        if ($this->id == 7) {
            $now = Carbon::now();
            // $now = Carbon::parse('2024-02-27 08:30:00');
            // $now = Carbon::parse('2024-02-27 14:06:00');
            // $now = Carbon::parse('2024-02-28 00:30:00');
            // $now = Carbon::parse('2024-02-28 04:02:00'); //working game showing coff
        } else {
            $now = Carbon::now();
        }

        //so all times are based on $now for proper testing & comparison
        $openTime = Carbon::parse($this->open_time)->setDate($now->year, $now->month, $now->day);
        $closeTime = Carbon::parse($this->close_time)->setDate($now->year, $now->month, $now->day);

        // Log::info('Open Time: ' . $openTime);
        // Log::info('Close Time: ' . $closeTime);
        // Log::info('Now: ' . $now);


        //if close time is less than open time, it means close time is on next day
        if ($closeTime->lt($openTime)) {
            if ($now->lt($closeTime)) {
                $openTime->subDay();
            } else {
                $closeTime->addDay();
            }
        }

        // Log::info('Open Time: ' . $openTime);
        // Log::info('Close Time: ' . $closeTime);
        // Log::info('');

        if (!$now->between($openTime, $closeTime)) {
            return false;
        }

        return true;
    }
}
