<?php

namespace App\Jobs;

use App\Models\Otp;
use App\Models\DesawarRecord;
use App\Models\MarketRecord;
use App\Models\StartLineRecord;
use App\Models\Transaction;
use App\Models\UpiTransaction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteExpiredOtps implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct()
    {
        //
    }

    public function handle(): void
    {
        Otp::whereDate('created_at', '<=', now()->subMinutes(30))->delete();
        
        Transaction::whereDate('created_at', '<=', now()->subDays(15))->delete();
        StartLineRecord::whereDate('created_at', '<=', now()->subDays(30))->delete();
        DesawarRecord::whereDate('created_at', '<=', now()->subDays(30))->delete();
        MarketRecord::whereDate('created_at', '<=', now()->subDays(30))->delete();
        UpiTransaction::whereDate('created_at', '<=', now()->subDays(15))->delete();
    }
}
