<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use Symfony\Component\HttpFoundation\Response;

class CheckAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (
            (auth()->user()->role !== 'admin' && auth()->user()->role !== 'sub-admin')
            || auth()->user()->blocked === 1
        ) {
            return redirect()->back();
        }
        if(auth()->check()) {
            $last_login = auth()->user()->last_users_view;
            if ($last_login === null) {
                $last_login = now()->subDays(1);
            }
            $users_count_after_login = User::where('role', 'user')->where('created_at', '>', $last_login)->count();
            View::share('users_count_after_login', $users_count_after_login);
        }
        
        return $next($request);
    }
}
