<?php

namespace App\Http\Controllers;

use App\Models\AppData;
use App\Models\DepositHistory;
use App\Models\DesawarMarket;
use App\Models\GameType;
use App\Models\Market;
use App\Models\SliderImage;
use App\Models\StartLineMarket;
use App\Models\User;
use Illuminate\Support\Str;

class HomeController extends Controller
{
    public function privacy()
    {
        return view('webapp.privacy');
    }

    public function verifyUTR($id, $utr, $amount)
    {
        $website = User::where('id', $id)->first();
        if ($website === NULL) {
            $response = [
                "error" => true,
                "message" => "Invalid User"
            ];
            return response()->json($response);
        }

        $payment = DepositHistory::where('utr', $utr)->first();
        if ($payment !== NULL) {
            $response = [
                "error" => true,
                "message" => "UTR already submitted, Please wait for Admin Confirmation or Enter new UTR"
            ];
            return response()->json($response);
        }

        $submit_utr = new DepositHistory();
        $submit_utr->user_id = $id;
        $submit_utr->utr = $utr;
        $submit_utr->amount = $amount;
        $submit_utr->transaction_id = Str::random(12);
        $submit_utr->save();

        $response = [
            "error" => false,
            "message" => "UTR submitted"
        ];
        return response()->json($response);
    }

    public function payment($user_id, $amount)
    {
        $appData = AppData::first();
        $user = User::find($user_id);
        return view('webapp.payment', compact('user', 'amount', 'appData'));
    }

    public function charts()
    {
        $appData = AppData::first();
        $desawarMarkets = DesawarMarket::with('results')->where('disable_game', false)->latest()->get();

        if ($appData->enable_desawar_only) {
            return view(
                'webapp.charts',
                compact('desawarMarkets', 'appData')
            );
        }

        $startLineMarkets = StartLineMarket::with('results')->where('disable_game', false)->latest()->get();
        $markets = Market::with('results')->where('disable_game', false)->latest()->get();
        return view(
            'webapp.charts',
            compact('startLineMarkets', 'markets', 'desawarMarkets', 'appData')
        );
    }

    public function index()
    {
        $appData = AppData::first();
        $sliderImages = SliderImage::all();
        if ($appData->enable_desawar_only) {
            $gameTypes = GameType::where('type', 'desawar')->get();
        } else {
            $gameTypes = GameType::all();
        }

        $desawarMarkets = DesawarMarket::with('results')->where('disable_game', false)
            ->orderBy('open_time', 'asc')
            ->get();

        if ($appData->enable_desawar_only) {
            return view(
                'webapp.index',
                compact('gameTypes', 'desawarMarkets', 'sliderImages', 'appData')
            );
        }

        $startLineMarkets = StartLineMarket::with('results')
            ->orderBy('open_time', 'asc')
            ->get();

        //markets order by open time
        $markets = Market::with('results')->where('disable_game', false)
            ->orderBy('open_time', 'asc')
            ->get();
        return view(
            'webapp.index',
            compact('gameTypes', 'startLineMarkets', 'markets', 'desawarMarkets', 'sliderImages', 'appData')
        );
    }

    public function chart()
    {
        return view('webapp.chart');
    }

    public function getDropboxAccessToken()
    {
        $client = new \GuzzleHttp\Client();
        $response = $client->post("https://api.dropbox.com/oauth2/token", [
            'form_params' => [
                "grant_type" => "refresh_token",
                // "refresh_token" => "nhnbLUNJWgUAAAAAAAAAAbiR1hVMS9J5BjjDmpMB9Q2XlWyLcRWFpqk-VrZA2SCg",  // Permanent refresh token
                "refresh_token" => "vzfxaa7aWckAAAAAAAAAAX8GSFfNoLZicAuyE6pNy2o-JOmhw5eyKeMTcSdyWNSU",  // Permanent refresh token
                "client_id" => "76k6d708klmlxbf",
                "client_secret" => "m770rzb5mhl8kjm",
            ],
        ]);
    
        $data = json_decode($response->getBody(), true);
        return $data['access_token']; // Use this token for Dropbox API calls
    }

    public function download()
    {
        $dropboxAccessToken = $this->getDropboxAccessToken();
        $dropboxFilePath = "/rama_app.apk"; // Path inside Dropbox

        $client = new \GuzzleHttp\Client();
        $response = $client->post("https://api.dropboxapi.com/2/files/get_temporary_link", [
            'headers' => [
                "Authorization" => "Bearer {$dropboxAccessToken}",
                "Content-Type" => "application/json",
            ],
            'json' => [
                "path" => $dropboxFilePath,
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        $directUrl = $data["link"];

        return redirect()->away($directUrl);
    }
}
