<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\DesawarMarket;
use App\Models\DesawarRecord;
use App\Models\Market;
use App\Models\MarketRecord;
use App\Models\StartLineMarket;
use App\Models\StartLineRecord;
use Illuminate\Http\Request;

class ProfitController extends Controller
{
    public function index(Request $request)
    {
        $data = [];
        if ($request->has('type') && $request->has('market_id')) {
            $modelDetails = match ($request->type) {
                'market'  => MarketRecord::class,
                'desawar_market'  => DesawarRecord::class,
                'startline_market'  => StartLineRecord::class,
            };

            $totalBidQuery = $modelDetails::whereYear('created_at', $request->query('year', 2024));

            if ($request->filled('market_id')) {
                $totalBidQuery->where("$request->type" . "_id", $request->market_id);
            }

            $userWinQuery = clone $totalBidQuery;

            if ($request->filled('month')) {
                $totalBidQuery->whereMonth('created_at', $request->month);
                $userWinQuery->whereMonth('created_at', $request->month);
            }

            if ($request->filled('day')) {
                $totalBidQuery->whereDay('created_at', $request->day);
                $userWinQuery->whereDay('created_at', $request->day);
            }

            $totalBidAmount = $totalBidQuery->sum('amount');
            $totalWinAmount = $userWinQuery->sum('win_amount');

            $data = [
                'totalBidAmount' => $totalBidAmount,
                'totalWinAmount' => $totalWinAmount,
                'profit' => $totalBidAmount - $totalWinAmount
            ];
        }

        $markets = Market::all();
        $desawarMarkets = DesawarMarket::all();
        $startlineMarkets = StartLineMarket::all();

        return view(
            'dashboard.profits.index',
            compact('markets', 'desawarMarkets', 'startlineMarkets', 'data')
        );
    }
}
