<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\DesawarMarket;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DesawarRecord;
use App\Models\GameType;
use App\Services\DesawarRecordChartService;
use Illuminate\Support\Facades\DB;

class DesawarMarketController extends Controller
{
    public function index(Request $request)
    {
        if ($request->has('searchValue')) {
            $searchValue = $request->searchValue;
            $desawarMarkets = DesawarMarket::where('name', 'LIKE', '%' . $searchValue . '%')
                ->latest()->paginate(250);
            return view("dashboard.desawar-markets.index", compact('desawarMarkets', 'searchValue'));
        }
        $desawarMarkets = DesawarMarket::latest()->paginate(25);
        return view("dashboard.desawar-markets.index", compact('desawarMarkets'));
    }

    public function create()
    {
        return view('dashboard.desawar-markets.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'api_key_name' => 'required|max:255',
            'disable_game' => 'required|boolean',
            'previous_day_check' => 'required|boolean',
            'open_time' => 'required',
            'close_time' => 'required',
            'result_time' => 'required',
        ]);
        DesawarMarket::create($request->all());
        return redirect()->route('desawar-markets.index')->with('success', 'Market Created successfully');
    }

    public function edit($id)
    {
        $market = DesawarMarket::findOrFail($id);
        return view('dashboard.desawar-markets.create', compact('market'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255',
            'api_key_name' => 'required|max:255',
            'previous_day_check' => 'required|boolean',
            'open_time' => 'required',
            'close_time' => 'required',
            'result_time' => 'required',
        ]);
        $market = DesawarMarket::findOrFail($id);
        $market->name = $request->name;
        $market->disable_game = $request->disable_game;
        $market->previous_day_check = $request->previous_day_check;
        $market->open_time = $request->open_time;
        $market->close_time = $request->close_time;
        $market->result_time = $request->result_time;
        $market->api_key_name = $request->api_key_name;
        $market->auto_result = $request->auto_result;
        $market->update();
        return redirect()->route('desawar-markets.index')->with('success', 'Market Update successfully');
    }

    public function destroy($id)
    {
        $market = DesawarMarket::findOrFail($id);
        foreach ($market->records as $record) {
            $record->delete();
        }
        foreach ($market->results as $result) {
            $result->delete();
        }
        $market->delete();
        return redirect()->route('desawar-markets.index')->with('success', 'Market Deleted successfully');
    }

    public function chart()
    {
        $chartData = DesawarRecordChartService::getChartData();
        return view('dashboard.desawar-markets.chart', [...$chartData]);
    }
}
