<?php

namespace App\Http\Controllers\Dashboard;

use App\Models\AppData;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class AppDataController extends Controller
{
    public function index()
    {
        $appData = AppData::first();
        return view('dashboard.app-data.index', compact('appData'));
    }

    public function store(Request $request)
    {
        if (!env('ALLOW_EDITING')) {
            return redirect()->back()->with('success', 'Please Don"t Change anything while development.');
        }

        $request->validate([
            'version' => 'required|integer',
            'withdrawal_fee' => 'numeric|sometimes|nullable',
            'home_message' => 'required|string|max:255',
            'support_number' => 'required|string|max:255',
            'support_time' => 'required|string|max:255',
            'withdrawal_condition' => 'required|string',
            'rules_notice' => 'required|string',
            'min_bid_amount' => 'required|integer|min:1',
            'max_bid_amount' => 'required|integer|min:1',
            'min_withdraw' => 'required|integer|min:1',
            'min_deposit' => 'required|integer|min:1',
            'invite_bonus_1st_time' => 'required|numeric',
            'invite_bonus_2nd_time' => 'required|numeric',
            'invite_system_enable' => 'required|boolean',
            'welcome_bonus' => 'required|integer',
            'admin_upi' => 'required|string|max:255',
            'telegram_enable' => 'required|boolean',
            'telegram_link' => 'nullable|url|max:255',
            'whatsapp_enable' => 'required|boolean',
            'whatsapp_number' => 'nullable|string|max:255',
            'withdraw_open_time' => 'required',
            'withdraw_close_time' => 'required',
            'payment_method' => ['required', Rule::in(['auto', 'manual', 'direct_upi', 'ibr_pay', 'upi_money', 'pay_from_upi'])],
            'auto_result_api' => 'nullable|url|max:255',
            'sms_api_key' => 'nullable|string|max:255',
            'fcm_key' => 'nullable|string|max:255',
            'bank_withdraw_enable' => 'required|boolean',
            'upi_withdraw_enable' => 'required|boolean',
            'enable_desawar' => 'required|boolean',
            'enable_desawar_only' => 'required|boolean',
            'maintain_mode' => 'required|boolean',
            'homepage_image_url'  => 'image|sometimes|nullable',
            'slider_url'  => 'string|sometimes|nullable|url',
            'upi_image'  => 'image|sometimes|nullable',
            'upi_gateway_key'  => 'string|sometimes|nullable',
            'play_store' => 'required|boolean',
            'show_results_only' => 'sometimes|nullable|boolean',
            'payfromupi_api_key' => 'sometimes|nullable|string',
            'self_recharge_bonus' => 'sometimes|nullable|numeric',
        ]);

        $requestData = $request->all();
        if ($request->hasFile('upi_image')) {
            $path = Storage::disk('public')->put('', $request->upi_image);
            $requestData['upi_image'] = Storage::url($path);
        }

        if ($request->hasFile('homepage_image_url')) {
            $path = Storage::disk('public')->put('', $request->homepage_image_url);
            $requestData['homepage_image_url'] = Storage::url($path);
        }

        AppData::updateOrCreate([], $requestData);
        return redirect()->back()->with('success', ' App Data updated successfully');
    }
}
