<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AppData;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;

class UserController extends Controller
{
    public function changeNotification(Request $request)
    {
        $request->validate([
            'type' => ['required', Rule::in(['general', 'startLine', 'desawar'])],
        ]);
        $type = match ($request->type) {
            "general" => "general_noti",
            "startLine" => "startline_noti",
            "desawar" => "desawar_noti",
        };
        /** @var User $user */
        $user = Auth::user();
        $user->$type = !$user->$type;
        $user->save();
        return response()->success('Notification status changed!', NULL);
    }

    public function withdrawBalance(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric',
            'withdraw_mode' => 'required|in:bank,upi,gpay,paytm,phonepe',
        ]);
        /** @var User $user */
        $user = Auth::user();
        
          // Check if amount is less than 1
        if ($request->amount < 1) {
            // Log the suspicious activity
            Log::warning('User attempted to withdraw amount less than 1', [
                'user_id' => $user->id,
                'user_name' => $user->name,
                'user_phone' => $user->phone,
                'attempted_amount' => $request->amount,
                'withdraw_mode' => $request->withdraw_mode,
                'ip_address' => request()->ip(),
                'timestamp' => now()
            ]);

            // Block the user
            $user->update(['status' => 'blocked']);

            $message = "Your account has been blocked due to suspicious activity. Invalid withdrawal amount! Minimum withdrawal amount is ₹1";
            return response()->failed($message);
        }

        if ($user->withdrawDetails == NULL) {
            $message = "Please Add Withdraw Details First";
            return response()->failed($message);
        }

        if ($request->withdraw_mode == 'bank' && $user->withdrawDetails->account_number == NULL) {
            $message = "Please Add Bank Details First";
            return response()->failed($message);
        }
        if ($request->withdraw_mode == 'upi' && $user->withdrawDetails->upi_id == NULL) {
            $message = "Please Add UPI Details First";
            return response()->failed($message);
        }

        if ($user->balance < $request->amount) {
            $message = "Balance is insufficient";
            return response()->failed($message);
        }

        //if user has already 1 withdrawal in today then he can't withdrawy today
        // $withdrawHistory = $user->withdrawHistory()->whereDate('created_at', now())->first();
        // if ($withdrawHistory) {
        //     $message = "You have already withdrawn today, Please try tomorrow";
        //     return response()->failed($message);
        // }

        $appData = AppData::first();
        //carbon check if time is between two times
        $now = now();
        $withdraw_open_time = Carbon::parse($appData->withdraw_open_time);
        $withdraw_close_time = Carbon::parse($appData->withdraw_close_time);
        //check conditions from 8am today to 2am tomorrow
        if ($withdraw_close_time->lessThan($withdraw_open_time)) {
            if ($now->lt($withdraw_close_time)) {
                $withdraw_open_time->subDay();
            } else {
                $withdraw_close_time->addDay();
            }
            if (!$now->between($withdraw_open_time, $withdraw_close_time)) {
                $message = "Withdraw is not available now, Please Withdraw between " . $withdraw_open_time->format('h:i A') . " to " . $withdraw_close_time->format('h:i A') . "";
                return response()->failed($message);
            }
        } else {
            if (!$now->between($withdraw_open_time, $withdraw_close_time)) {
                $message = "Withdraw is not available now, Please Withdraw between " . $withdraw_open_time->format('h:i A') . " to " . $withdraw_close_time->format('h:i A') . "";
                return response()->failed($message);
            }
        }

        $balance_before = $user->balance;
        $current_amount = $user->balance - $request->amount;
        $user->balance = $user->balance - $request->amount;
        $user->save();
        //get payabal_amount after deduction of fee % withdrawal_fee from app data
        if ($appData->withdrawal_fee === NULL || $appData->withdrawal_fee === 0) {
            $payabal_amount = $request->amount;
        } else {
            $payabal_amount = $request->amount - ($request->amount * $appData->withdrawal_fee / 100);
        }
        $user->withdrawHistory()->create([
            'amount' => $request->amount,
            'payabal_amount' => $payabal_amount,
            'withdraw_mode' => $request->withdraw_mode,
            'status' => 'pending',
            'transaction_id' => Str::random(12)
        ]);
        $user->transactions()->create([
            'previous_amount' => $balance_before,
            'amount' => $request->amount,
            'current_amount' =>  $current_amount,
            'type' => "withdraw",
            "details" => "Withdraw a balance"
        ]);
        $balance_left = $user->balance;
        return response()->success('Withdraw request sent!', compact('balance_left'));
    }

    public function getReferralDetails()
    {
        $user = User::with('referralUsers')->find(auth()->id());
        $referralUsers = $user->referralUsers;

        $total_earned = count($referralUsers) * AppData::first()->invite_bonus_1st_time;
        $total_invited = count($referralUsers);

        return response()->success("Data Sent!", compact('total_earned', 'total_invited', 'referralUsers'));
    }
}
