<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\DesawarMarket;
use App\Models\Market;
use App\Models\StartLineMarket;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class MarketController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'type' => ['required', Rule::in(['general', 'startLine', 'desawar'])],
        ]);

        $market = match ($request->type) {
            "general" => Market::class,
            "startLine" => StartLineMarket::class,
            "desawar" => DesawarMarket::class,
        };

        $property_name = match ($request->type) {
            "general" => "markets",
            "startLine" => "markets",
            "desawar" => "markets",
        };

        $markets = $market::orderBy('open_time', 'asc')
            ->get();
        return response()->success("Data Sent!", [$property_name => $markets]);
    }
}
