<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\DepositHistory;
use Illuminate\Http\Request;

class DepositHistoryController extends Controller
{
    public function getDepositHistory(Request $request)
    {
        $request->validate([
            'page' => 'required|numeric',
        ]);
        $depositHistory = DepositHistory::where('user_id', auth()->id())
            ->latest()->paginate(10, ['*'], 'deposit_history', $request->page);
        return response()->success("Data Sent!", compact('depositHistory'));
    }
}
