<?php

namespace App\Http\Controllers\Agent;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PlayHistoryController extends Controller
{
    public function index(Request $request)
    {
        $play_percentage = auth()->user()->play_percentage;
        $searchValue = $request->input('searchValue');
        $searchValueDate = $request->input('searchValueDate')
            ? Carbon::parse($request->input('searchValueDate'))->format('Y-m-d')
            : Carbon::today()->format('Y-m-d');

        $usersQuery = User::
            withSum(['marketRecords as total_game_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'amount')
            ->withSum(['startLineRecords as total_startLine_game_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'amount')
            ->withSum(['desawarRecords as total_desawar_game_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'amount')

            ->withSum(['marketRecords as total_market_win_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'win_amount')
            ->withSum(['startLineRecords as total_startLine_win_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'win_amount')
            ->withSum(['desawarRecords as total_desawar_win_amount_today' => function ($query) use ($searchValueDate) {
                $query->whereDate('created_at', $searchValueDate);
            }], 'win_amount')

            ->withSum(['withdrawHistory as total_withdraw_success_amount_today' => function ($query) use ($searchValueDate) {
                $query->where('status', 'success')->whereDate('created_at', $searchValueDate);
            }], 'amount')
            ->withSum(['depositHistory as total_deposit_success_amount_today' => function ($query) use ($searchValueDate) {
                $query->where('status', 'success')->whereDate('created_at', $searchValueDate);
            }], 'amount')

            ->selectRaw("
                users.*,
                CASE
                    WHEN ? > 0 THEN (
                        (
                            COALESCE((SELECT SUM(amount) FROM market_records WHERE user_id = users.id AND DATE(created_at) = ?), 0)
                            +
                            COALESCE((SELECT SUM(amount) FROM start_line_records WHERE user_id = users.id AND DATE(created_at) = ?), 0)
                            +
                            COALESCE((SELECT SUM(amount) FROM desawar_records WHERE user_id = users.id AND DATE(created_at) = ?), 0)
                        ) * ? / 100
                    )
                    ELSE 0
                END as agent_commission
            ", [$play_percentage, $searchValueDate, $searchValueDate, $searchValueDate, $play_percentage])

            // Filters
            ->where('role', 'user')
            ->where('user_id', Auth::id())
            ->when($searchValue, function ($query) use ($searchValue) {
                $query->where(function ($q) use ($searchValue) {
                    $q->where('name', 'LIKE', '%' . $searchValue . '%')
                        ->orWhere('phone', 'LIKE', '%' . $searchValue . '%');
                });
            })

            // Ordering and Pagination
            ->orderByRaw('(total_game_amount_today + total_startLine_game_amount_today + total_desawar_game_amount_today) DESC')
            ->latest();

        $users = $usersQuery->paginate(250);
        // dd($users);

        return view('agent.play-history.index', compact('users', 'searchValue', 'searchValueDate'));
    }
}
