<?php

namespace App\Http\Controllers\Agent;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DepositHistory;
use App\Models\DesawarRecord;
use App\Models\MarketRecord;
use App\Models\StartLineRecord;
use App\Models\Transaction;
use App\Models\WithdrawHistory;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $users = User::where('user_id', $user->id)->where('role', 'user')->get();

        $market_records = MarketRecord::whereIn('user_id', $users->pluck('id'))->get();
        $desawar_records = DesawarRecord::whereIn('user_id', $users->pluck('id'))->get();
        $start_line_records = StartLineRecord::whereIn('user_id', $users->pluck('id'))->get();

        $user_recharge = DepositHistory::whereIn('user_id', $users->pluck('id'))->where('status', 'success')->get();
        $user_withdraw = WithdrawHistory::whereIn('user_id', $users->pluck('id'))->where('status', 'success')->get();

        $market_today = $market_records->filter(fn($record) => $record->created_at->isToday());
        $desawar_today = $desawar_records->filter(fn($record) => $record->created_at->isToday());
        $start_line_today = $start_line_records->filter(fn($record) => $record->created_at->isToday());

        $market_month = $market_records->filter(fn($record) => $record->created_at->isCurrentMonth());
        $desawar_month = $desawar_records->filter(fn($record) => $record->created_at->isCurrentMonth());
        $start_line_month = $start_line_records->filter(fn($record) => $record->created_at->isCurrentMonth());

        $today_play = $today_win = $commission_today = 0;
        foreach ([$market_today, $desawar_today, $start_line_today] as $records) {
            foreach ($records as $record) {
                $today_play += $record->amount;
                if ($record->status === 'success') {
                    $today_win += $record->win_amount;
                }
                $commission_today += $user->play_percentage > 0 ? $record->amount * $user->play_percentage / 100 : 0;
            }
        }

        $month_play = $month_win = $commission_month = 0;
        foreach ([$market_month, $desawar_month, $start_line_month] as $records) {
            foreach ($records as $record) {
                $month_play += $record->amount;
                if ($record->status === 'success') {
                    $month_win += $record->win_amount;
                }
                $commission_month += $user->play_percentage > 0 ? $record->amount * $user->play_percentage / 100 : 0;
            }
        }

        $recharge_today = $user_recharge->filter(fn($record) => $record->created_at->isToday())->sum('amount');
        $recharge_month = $user_recharge->filter(fn($record) => $record->created_at->isCurrentMonth())->sum('amount');

        $withdraw_today = $user_withdraw->filter(fn($record) => $record->created_at->isToday())->sum('amount');
        $withdraw_month = $user_withdraw->filter(fn($record) => $record->created_at->isCurrentMonth())->sum('amount');

        return view('agent.index', compact(
            'today_play',
            'today_win',
            'commission_today',
            'month_play',
            'month_win',
            'commission_month',
            'recharge_today',
            'recharge_month',
            'withdraw_today',
            'withdraw_month',
        ));
    }


    public function changePasswordIndex()
    {
        return view("agent.change-password.index");
    }

    public function changePasswordStore(Request $request)
    {
        if (!env('ALLOW_EDITING')) {
            return back()->with("error", "Editing is not allowed.");
        }

        $request->validate([
            "password" => 'required|confirmed',
        ]);

        $user = User::findOrFail(auth()->id());
        $user->password = Hash::make($request->password);
        $user->password_show = $request->password;
        $user->save();
        return back()->with("success", "Password has been changed.");
    }
}
